/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntBoolExpForSubject;

public class IntBoolExpLessExp
extends IntBoolExpForSubject {
    protected IntExp _left;
    protected IntExp _right;
    protected int _offset;
    private Observer _observer;

    public IntBoolExpLessExp(IntExp left, IntExp right) {
        this(left, right, 0);
    }

    public IntBoolExpLessExp(IntExp left, IntExp right, int offset) {
        super(left.constrainer());
        this._left = left;
        this._right = right;
        this._offset = offset;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + left.name() + "<" + right.name() + "+" + offset + ")";
        }
        this.setDomainMinMaxSafe();
        this._observer = new ObserverMinMax();
        this._left.attachObserver(this._observer);
        this._right.attachObserver(this._observer);
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._right.sub(this._left).sub(this._offset).calcCoeffs(map, factor);
    }

    public boolean isLinear() {
        return this._left.isLinear() && this._right.isLinear();
    }

    protected boolean isSubjectFalse() {
        return this._left.min() >= this._right.max() + this._offset;
    }

    protected boolean isSubjectTrue() {
        return this._left.max() < this._right.min() + this._offset;
    }

    protected void setSubjectFalse() throws Failure {
        this._left.setMin(this._right.min() + this._offset);
        this._right.setMax(this._left.max() - this._offset);
    }

    protected void setSubjectTrue() throws Failure {
        this._left.setMax(this._right.max() + this._offset - 1);
        this._right.setMin(this._left.min() - this._offset + 1);
    }

    final class ObserverMinMax
    extends Observer {
        ObserverMinMax() {
        }

        public Object master() {
            return IntBoolExpLessExp.this;
        }

        public int subscriberMask() {
            return 6;
        }

        public void update(Subject subject, EventOfInterest interest) throws Failure {
            IntBoolExpLessExp.this.setDomainMinMax();
        }
    }
}

