/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.LinkedList;
import java.util.ListIterator;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpImpl;

public class IntExpArrayElement
extends IntExpImpl {
    private LinkedList _elements;
    private IntExp _index;
    private Observer _index_observer;
    private IntVar _result;

    public IntExpArrayElement(IntExpArray array, IntExp index) throws Failure {
        super(index.constrainer());
        if (this.constrainer().showInternalNames()) {
            this.name(array.name() + "[" + index.name() + "]");
        }
        this._index = index;
        this._index.setMin(0);
        this._index.setMax(array.size() - 1);
        this._elements = new LinkedList();
        int min = index.min();
        int max = index.max();
        for (int i = min; i <= max; ++i) {
            IntExp element = array.get(i);
            ArrayElementObserver observer = new ArrayElementObserver(element);
            element.attachObserver(observer);
            this._elements.add(new ArrayElementAndObserver(element, i, observer));
        }
        this._index_observer = new IndexObserver(this._elements, this._index);
        this._index.attachObserver(this._index_observer);
        int trace = 0;
        this._result = this.constrainer().addIntVarTraceInternal(this.calc_min(), this.calc_max(), array.name() + "[" + index.name() + "](internal)", 0, trace);
    }

    public int calc_max() {
        if (this._elements.size() == 1) {
            return ((ArrayElementAndObserver)this._elements.getFirst())._exp.max();
        }
        ListIterator iterator = this._elements.listIterator();
        int l_max = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            int e_max = ((ArrayElementAndObserver)iterator.next())._exp.max();
            if (e_max <= l_max) continue;
            l_max = e_max;
        }
        return l_max;
    }

    public int calc_min() {
        if (this._elements.size() == 1) {
            return ((ArrayElementAndObserver)this._elements.getFirst())._exp.min();
        }
        ListIterator iterator = this._elements.listIterator();
        int l_min = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            int e_min = ((ArrayElementAndObserver)iterator.next())._exp.min();
            if (e_min >= l_min) continue;
            l_min = e_min;
        }
        return l_min;
    }

    public int max() {
        return this._result.max();
    }

    public int min() {
        return this._result.min();
    }

    public void setMax(int max) throws Failure {
        this._result.setMax(max);
        if (this._elements.size() == 1) {
            ((IntExp)this._elements.getFirst()).setMax(max);
        }
    }

    public void setMin(int min) throws Failure {
        this._result.setMin(min);
        if (this._elements.size() == 1) {
            ((IntExp)this._elements.getFirst()).setMin(min);
        }
    }

    private class IndexObserver
    extends Observer {
        IntExp _index;
        LinkedList _elements;

        public IndexObserver(LinkedList elements, IntExp index) {
            this._elements = elements;
            this._index = index;
        }

        public Object master() {
            return IntExpArrayElement.this;
        }

        public int subscriberMask() {
            return 15;
        }

        public void update(Subject subject, EventOfInterest event) throws Failure {
            IntEvent i_event = (IntEvent)event;
            switch (event.type()) {
                case 2: {
                    int min = i_event.min();
                    while (!this._elements.isEmpty()) {
                        ArrayElementAndObserver element_and_observer = (ArrayElementAndObserver)this._elements.getFirst();
                        if (element_and_observer._index >= min) break;
                        element_and_observer._exp.detachObserver(element_and_observer._observer);
                        this._elements.removeFirst();
                    }
                    this.updateMinMax();
                    break;
                }
                case 4: {
                    int max = i_event.max();
                    while (!this._elements.isEmpty()) {
                        ArrayElementAndObserver element_and_observer = (ArrayElementAndObserver)this._elements.getLast();
                        if (element_and_observer._index <= max) break;
                        element_and_observer._exp.detachObserver(element_and_observer._observer);
                        this._elements.removeLast();
                    }
                    this.updateMinMax();
                    break;
                }
                case 1: 
                case 6: {
                    ArrayElementAndObserver element_and_observer;
                    int min = i_event.min();
                    while (!this._elements.isEmpty()) {
                        element_and_observer = (ArrayElementAndObserver)this._elements.getFirst();
                        if (element_and_observer._index >= min) break;
                        element_and_observer._exp.detachObserver(element_and_observer._observer);
                        this._elements.removeFirst();
                    }
                    int max = i_event.max();
                    while (!this._elements.isEmpty()) {
                        element_and_observer = (ArrayElementAndObserver)this._elements.getLast();
                        if (element_and_observer._index <= max) break;
                        element_and_observer._exp.detachObserver(element_and_observer._observer);
                        this._elements.removeLast();
                    }
                    this.updateMinMax();
                    break;
                }
                case 8: {
                    block10: for (int i = 0; i < i_event.numberOfRemoves(); ++i) {
                        int rem = i_event.removed(i);
                        ListIterator iterator = this._elements.listIterator();
                        while (iterator.hasNext()) {
                            ArrayElementAndObserver element_and_observer = (ArrayElementAndObserver)iterator.next();
                            if (element_and_observer._index != rem) continue;
                            element_and_observer._exp.detachObserver(element_and_observer._observer);
                            this._elements.remove(element_and_observer);
                            continue block10;
                        }
                    }
                    this.updateMinMax();
                }
            }
            if (this._elements.size() == 1) {
                ArrayElementAndObserver element_and_observer = (ArrayElementAndObserver)this._elements.getFirst();
                element_and_observer._exp.setMin(IntExpArrayElement.this._result.min());
                element_and_observer._exp.setMax(IntExpArrayElement.this._result.max());
            }
        }

        private void updateMinMax() throws Failure {
            IntExpArrayElement.this._result.setMin(IntExpArrayElement.this.calc_min());
            IntExpArrayElement.this._result.setMax(IntExpArrayElement.this.calc_max());
        }
    }

    private class ArrayElementObserver
    extends Observer {
        private IntExp _exp;

        public ArrayElementObserver(IntExp exp) {
            this._exp = exp;
        }

        public Object master() {
            return IntExpArrayElement.this;
        }

        public int subscriberMask() {
            return 15;
        }

        public void update(Subject subject, EventOfInterest event) throws Failure {
            IntEvent i_event = (IntEvent)event;
            if (i_event.min() > IntExpArrayElement.this._result.min()) {
                IntExpArrayElement.this._result.setMin(IntExpArrayElement.this.calc_min());
            }
            if (i_event.max() < IntExpArrayElement.this._result.max()) {
                IntExpArrayElement.this._result.setMax(IntExpArrayElement.this.calc_max());
            }
        }
    }

    private class ArrayElementAndObserver {
        public int _index;
        public IntExp _exp;
        public Observer _observer;

        public ArrayElementAndObserver(IntExp exp, int index, Observer observer) {
            this._index = index;
            this._exp = exp;
            this._observer = observer;
        }
    }
}

