/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntExpImpl;

public final class IntExpBitAndExp
extends IntExpImpl {
    private IntExp _exp1;
    private IntExp _exp2;
    private Observer _observer;
    private IntVar _and;

    public IntExpBitAndExp(IntExp exp1, IntExp exp2) {
        super(exp1.constrainer());
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp1.name() + "+" + exp2.name() + ")";
        }
        this._exp1 = exp1;
        this._exp2 = exp2;
        int trace = 0;
        this._and = this.constrainer().addIntVarTraceInternal(this.calc_min(), this.calc_max(), this._name, 0, trace);
        this._observer = new ExpBitAndExpObserver();
        this._exp1.attachObserver(this._observer);
        this._exp2.attachObserver(this._observer);
    }

    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._and.attachObserver(observer);
    }

    public int calc_max() {
        if (this._exp1.bound() && this._exp2.bound()) {
            return this._exp1.valueUnsafe() & this._exp2.valueUnsafe();
        }
        return Math.min(this._exp1.max(), this._exp2.max());
    }

    public int calc_min() {
        if (this._exp1.bound() && this._exp2.bound()) {
            return this._exp1.valueUnsafe() & this._exp2.valueUnsafe();
        }
        return 0;
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        throw new NonLinearExpression(this);
    }

    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._and.detachObserver(observer);
    }

    public boolean isLinear() {
        return false;
    }

    public int max() {
        return this._and.max();
    }

    public int min() {
        return this._and.min();
    }

    public void onMaskChange() {
    }

    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._and.reattachObserver(observer);
    }

    public void removeValue(int value) throws Failure {
        int Max = this.max();
        if (value > Max) {
            return;
        }
        int Min = this.min();
        if (value < Min) {
            return;
        }
        if (Min == Max) {
            this.constrainer().fail("remove for IntExpAddExp");
        }
        if (value == Max) {
            this.setMax(value - 1);
        }
        if (value == Min) {
            this.setMin(value + 1);
        }
    }

    public void setMax(int max) throws Failure {
    }

    public void setMin(int min) throws Failure {
    }

    public void setValue(int value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    class ExpBitAndExpObserver
    extends Observer {
        ExpBitAndExpObserver() {
        }

        public Object master() {
            return IntExpBitAndExp.this;
        }

        public int subscriberMask() {
            return 1;
        }

        public String toString() {
            return "ExpAddExpObserver: ";
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntExpBitAndExp.this._and.setMin(IntExpBitAndExp.this.calc_min());
            IntExpBitAndExp.this._and.setMax(IntExpBitAndExp.this.calc_max());
        }
    }
}

