/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.LinkedList;
import java.util.ListIterator;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntArrayCards;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpCard;
import org.openl.ie.constrainer.impl.IntExpImpl;

public class IntExpCardIntExp
extends IntExpImpl {
    private IntVar _result;
    private IntExp _exp;
    private LinkedList _cards;
    private IntExpCardIntExpObserver _exp_observer;

    public IntExpCardIntExp(IntExpArray array, IntExp exp) throws Failure {
        super(exp.constrainer());
        if (this.constrainer().showInternalNames()) {
            this.name("C{" + array.name() + "/" + exp.name() + "}");
        }
        this._exp = exp;
        this._cards = new LinkedList();
        int min = this._exp.min();
        int max = this._exp.max();
        IntArrayCards cards = array.cards();
        for (int i = min; i <= max; ++i) {
            if (!this._exp.contains(i)) continue;
            IntExpCard card = cards.cardAt(i);
            IntExpCardCardinalityObserver observer = new IntExpCardCardinalityObserver(card);
            card.attachObserver(observer);
            this._cards.add(new IntExpAndObserver(card, observer));
        }
        this._exp_observer = new IntExpCardIntExpObserver(this._cards, this._exp);
        this._exp.attachObserver(this._exp_observer);
        int trace = 0;
        this._result = this.constrainer().addIntVarTraceInternal(this.calc_min(), this.calc_max(), "IX{" + array.name() + "/" + exp.name() + "}", 0, trace);
    }

    public int calc_max() {
        if (this._cards.size() == 1) {
            return ((IntExpCard)((IntExpAndObserver)this._cards.getFirst())._exp).max();
        }
        ListIterator iterator = this._cards.listIterator();
        int l_max = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            int e_max = ((IntExpCard)((IntExpAndObserver)iterator.next())._exp).max();
            if (e_max <= l_max) continue;
            l_max = e_max;
        }
        return l_max;
    }

    public int calc_min() {
        if (this._cards.size() == 1) {
            return ((IntExpCard)((IntExpAndObserver)this._cards.getFirst())._exp).min();
        }
        ListIterator iterator = this._cards.listIterator();
        int l_min = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            int e_min = ((IntExpCard)((IntExpAndObserver)iterator.next())._exp).min();
            if (e_min >= l_min) continue;
            l_min = e_min;
        }
        return l_min;
    }

    public int max() {
        return this._result.max();
    }

    public int min() {
        return this._result.min();
    }

    public void setMax(int max) throws Failure {
        this._result.setMax(max);
        if (this._cards.size() == 1) {
            ((IntExpCard)this._cards.get(0)).setMax(max);
        }
    }

    public void setMin(int min) throws Failure {
        this._result.setMin(min);
        if (this._cards.size() == 1) {
            ((IntExpCard)this._cards.get(0)).setMin(min);
        }
    }

    private class IntExpCardIntExpObserver
    extends Observer {
        IntExp _exp;
        LinkedList _cards;

        public IntExpCardIntExpObserver(LinkedList cards, IntExp exp) {
            this._cards = cards;
            this._exp = exp;
        }

        public Object master() {
            return IntExpCardIntExp.this;
        }

        public int subscriberMask() {
            return 15;
        }

        public void update(Subject subject, EventOfInterest event) throws Failure {
            IntEvent i_event = (IntEvent)event;
            switch (event.type()) {
                case 2: {
                    int min = i_event.min();
                    while (!this._cards.isEmpty()) {
                        IntExpAndObserver exp_and_observer = (IntExpAndObserver)this._cards.getFirst();
                        if (((IntExpCard)exp_and_observer._exp).get_cardinality_value() >= min) break;
                        exp_and_observer._exp.detachObserver(exp_and_observer._observer);
                        this._cards.removeFirst();
                    }
                    this.updateMinMax();
                    break;
                }
                case 4: {
                    int max = i_event.max();
                    while (!this._cards.isEmpty()) {
                        IntExpAndObserver exp_and_observer = (IntExpAndObserver)this._cards.getLast();
                        if (((IntExpCard)exp_and_observer._exp).get_cardinality_value() <= max) break;
                        exp_and_observer._exp.detachObserver(exp_and_observer._observer);
                        this._cards.removeLast();
                    }
                    this.updateMinMax();
                    break;
                }
                case 1: 
                case 6: {
                    IntExpAndObserver exp_and_observer;
                    int min = i_event.min();
                    while (!this._cards.isEmpty()) {
                        exp_and_observer = (IntExpAndObserver)this._cards.getFirst();
                        if (((IntExpCard)exp_and_observer._exp).get_cardinality_value() >= min) break;
                        exp_and_observer._exp.detachObserver(exp_and_observer._observer);
                        this._cards.removeFirst();
                    }
                    int max = i_event.max();
                    while (!this._cards.isEmpty()) {
                        exp_and_observer = (IntExpAndObserver)this._cards.getLast();
                        if (((IntExpCard)exp_and_observer._exp).get_cardinality_value() <= max) break;
                        exp_and_observer._exp.detachObserver(exp_and_observer._observer);
                        this._cards.removeLast();
                    }
                    this.updateMinMax();
                    break;
                }
                case 8: {
                    block10: for (int i = 0; i < i_event.numberOfRemoves(); ++i) {
                        int rem = i_event.removed(i);
                        ListIterator iterator = this._cards.listIterator();
                        while (iterator.hasNext()) {
                            IntExpAndObserver exp_and_observer = (IntExpAndObserver)iterator.next();
                            if (((IntExpCard)exp_and_observer._exp).get_cardinality_value() != rem) continue;
                            exp_and_observer._exp.detachObserver(exp_and_observer._observer);
                            this._cards.remove(exp_and_observer);
                            continue block10;
                        }
                    }
                    this.updateMinMax();
                }
            }
        }

        public void updateMinMax() throws Failure {
            IntExpCardIntExp.this._result.setMin(IntExpCardIntExp.this.calc_min());
            IntExpCardIntExp.this._result.setMax(IntExpCardIntExp.this.calc_max());
        }
    }

    private class IntExpCardCardinalityObserver
    extends Observer {
        private IntExpCard _exp;

        public IntExpCardCardinalityObserver(IntExpCard exp) {
            this._exp = exp;
        }

        public Object master() {
            return IntExpCardIntExp.this;
        }

        public int subscriberMask() {
            return 15;
        }

        public void update(Subject subject, EventOfInterest event) throws Failure {
            IntEvent i_event = (IntEvent)event;
            if (i_event.min() > IntExpCardIntExp.this._result.min()) {
                IntExpCardIntExp.this._result.setMin(IntExpCardIntExp.this.calc_min());
            }
            if (i_event.max() < IntExpCardIntExp.this._result.max()) {
                IntExpCardIntExp.this._result.setMax(IntExpCardIntExp.this.calc_max());
            }
        }
    }

    private class IntExpAndObserver {
        public IntExp _exp;
        public Observer _observer;

        public IntExpAndObserver(IntExp exp, Observer observer) {
            this._exp = exp;
            this._observer = observer;
        }
    }
}

