/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.impl.IntExpImpl;

public class IntExpDivExp2
extends IntExpImpl {
    private IntExp _dividend;
    private IntExp _divisor;
    private IntExp _quotient;
    private IntExp _remainder;

    public IntExpDivExp2(IntExp dividend, IntExp divisor) throws Failure {
        super(dividend.constrainer());
        this._dividend = dividend;
        this._divisor = divisor;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + dividend.name() + "/" + divisor.name() + ")";
        }
        int trace = 0;
        int domain = 0;
        this._quotient = this.constrainer().addIntVarTraceInternal(this.calc_min(), this.calc_max(), "div", domain, trace);
        int tmp = Math.max(Math.abs(this._divisor.min()), Math.abs(this._divisor.max()));
        this._remainder = this.constrainer().addIntVarTraceInternal(-1 * tmp + 1, tmp - 1, "div", domain, trace);
        this.constrainer().postConstraint(this._quotient.mul(this._divisor).add(this._remainder).equals(this._dividend));
        this.constrainer().postConstraint(this._quotient.mul(this._divisor).abs().lessOrEqual(this._dividend.abs()));
        this.constrainer().postConstraint(this._remainder.abs().less(this._divisor.abs()));
    }

    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._quotient.attachObserver(observer);
    }

    private int calc_max() {
        int min1 = this._dividend.min();
        int max1 = this._dividend.max();
        int min2 = this._divisor.min();
        int max2 = this._divisor.max();
        if (max2 > 0 && min2 < 0) {
            return Math.max(Math.abs(min1), Math.abs(min2));
        }
        return Math.max(Math.max(min1 / min2, min1 / max2), Math.max(max1 / min2, max1 / max2));
    }

    private int calc_min() {
        int min1 = this._dividend.min();
        int max1 = this._dividend.max();
        int min2 = this._divisor.min();
        int max2 = this._divisor.max();
        if (max2 > 0 && min2 < 0) {
            return -Math.max(Math.abs(min1), Math.abs(min2));
        }
        return Math.min(Math.min(min1 / min2, min1 / max2), Math.min(max1 / min2, max1 / max2));
    }

    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._quotient.detachObserver(observer);
    }

    public int max() {
        return this._quotient.max();
    }

    public int min() {
        return this._quotient.min();
    }

    public void name(String name) {
        super.name(name);
        this._quotient.name(name);
    }

    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._quotient.reattachObserver(observer);
    }

    public void setMax(int max) throws Failure {
        if (max >= this.max()) {
            return;
        }
        this._quotient.setMax(max);
    }

    public void setMin(int min) throws Failure {
        if (min <= this.min()) {
            return;
        }
        this._quotient.setMin(min);
    }

    public void setValue(int val) throws Failure {
        this.setMin(val);
        this.setMax(val);
    }
}

