/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.IntExpImpl;

public class IntExpDivValue
extends IntExpImpl {
    private static final int[] event_map = new int[]{6, 2, 6, 4, 1, 1};
    private IntExp _dividend;
    private int _divisor;
    private IntExp _quotient;
    private IntExpDivValueObserver _observer;

    public IntExpDivValue(IntExp dividend, int divisor) {
        super(dividend.constrainer());
        this._dividend = dividend;
        this._divisor = divisor;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + dividend.name() + "/" + divisor + ")";
        }
        this._observer = new IntExpDivValueObserver();
        this._dividend.attachObserver(this._observer);
        int trace = 0;
        int domain = 0;
        this._quotient = this.constrainer().addIntVarTraceInternal(this.calc_min(), this.calc_max(), "div", domain, trace);
    }

    int calc_max() {
        if (this._divisor > 0) {
            return this._dividend.max() / this._divisor;
        }
        return this._dividend.min() / this._divisor;
    }

    int calc_min() {
        if (this._divisor > 0) {
            return this._dividend.min() / this._divisor;
        }
        return this._dividend.max() / this._divisor;
    }

    public int max() {
        return this._quotient.max();
    }

    public int min() {
        return this._quotient.min();
    }

    public void setMax(int max) throws Failure {
        this._quotient.setMax(max);
        if (this._divisor > 0) {
            if (max < 0) {
                this._dividend.setMax(max * this._divisor);
            } else {
                this._dividend.setMax((max + 1) * this._divisor - 1);
            }
        } else if (max < 0) {
            this._dividend.setMin(max * this._divisor);
        } else {
            this._dividend.setMin((max + 1) * this._divisor - 1);
        }
    }

    public void setMin(int min) throws Failure {
        this._quotient.setMin(min);
        if (this._divisor > 0) {
            if (min > 0) {
                this._dividend.setMin(min * this._divisor);
            } else {
                this._dividend.setMin((min - 1) * this._divisor + 1);
            }
        } else if (min > 0) {
            this._dividend.setMax(min * this._divisor);
        } else {
            this._dividend.setMax((min - 1) * this._divisor + 1);
        }
    }

    class IntExpDivValueObserver
    extends ExpressionObserver {
        IntExpDivValueObserver() {
            super(event_map);
        }

        public Object master() {
            return IntExpDivValue.this;
        }

        public String toString() {
            return "IntExpDivExpObserver: (" + IntExpDivValue.this._dividend.name() + "/" + IntExpDivValue.this._divisor + ")";
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntExpDivValue.this._quotient.setMin(IntExpDivValue.this.calc_min());
            IntExpDivValue.this._quotient.setMax(IntExpDivValue.this.calc_max());
        }
    }
}

