/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntArray;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntCalc;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpEnum;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;
import org.openl.ie.tools.ReusableImpl;

public final class IntExpElementAt
extends IntExpImpl {
    private IntArray _ary;
    private IntExp _indexExp;
    private IntVar _index;
    private IntExp _element;
    private Mapping _m;

    static int findIndex(IntExp index, IntArray ary, int value) {
        FindValueIterator it = FindValueIterator.getIterator(index, ary, value);
        try {
            index.iterateDomain(it);
        }
        catch (Failure f) {
            // empty catch block
        }
        int foundIndex = it.foundIndex;
        it.free();
        return foundIndex;
    }

    static boolean indexHasValue(IntExp index, IntArray ary, int value) {
        return IntExpElementAt.findIndex(index, ary, value) >= 0;
    }

    public IntExpElementAt(IntArray ary, IntExp indexExp) {
        super(ary.constrainer());
        this._ary = ary;
        this._indexExp = indexExp;
        if (this.constrainer().showInternalNames()) {
            this._name = "" + this._ary.name() + "[" + this._indexExp.name() + "]";
        }
        try {
            this.createIndex();
            this.createElement();
            this.constrainer().propagate();
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid elementAt-expression: " + ary + "[" + indexExp + "]. " + e.getClass().getName() + ": " + e.getMessage());
        }
        this.createMapping();
        this._index.attachObserver(new IndexObserver());
        this._element.attachObserver(new ElementObserver());
    }

    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._element.attachObserver(observer);
    }

    public boolean contains(int value) {
        return this._element.contains(value);
    }

    void createElement() throws Failure {
        int size;
        int min;
        int[] values = this.elementDomain();
        int max = values[values.length - 1];
        int nHoles = max - (min = values[0]) + 1 - (size = values.length);
        if (nHoles < 10) {
            this.createElement1(values);
        } else {
            this.createElement2(values);
        }
    }

    void createElement1(int[] values) throws Failure {
        int trace = 0;
        int min = values[0];
        int max = values[values.length - 1];
        String name = "";
        if (this.constrainer().showInternalNames()) {
            name = "element_" + this._ary.name() + "[" + this._indexExp.name() + "]";
        }
        this._element = this.constrainer().addIntVarTraceInternal(min, max, name, 1, trace);
        int i = 0;
        while (i + 1 < values.length) {
            for (int value = values[i] + 1; value < values[i + 1] - 1; ++value) {
                this._element.removeValue(value);
            }
            ++i;
        }
    }

    void createElement2(int[] values) throws Failure {
        String name = "";
        if (this.constrainer().showInternalNames()) {
            name = "element_" + this._ary.name() + "[" + this._indexExp.name() + "]";
        }
        this._element = new IntExpEnum(this.constrainer(), values, name);
    }

    void createIndex() throws Failure {
        boolean effectiveIndexExp = this._indexExp instanceof IntVar && ((IntVar)this._indexExp).domainType() != 0;
        int max = this._ary.size() - 1;
        if (effectiveIndexExp) {
            this._index = (IntVar)this._indexExp;
            this._index.setMin(0);
            this._index.setMax(max);
        } else {
            int trace = 0;
            String name = "";
            if (this.constrainer().showInternalNames()) {
                name = "index_" + this._ary.name() + "[" + this._indexExp.name() + "]";
            }
            this._index = this.constrainer().addIntVarTraceInternal(0, max, name, 1, trace);
            for (int i = 0; i <= max; ++i) {
                if (this._indexExp.contains(i)) continue;
                this._index.removeValue(i);
            }
            this._index.equals(this._indexExp).post();
        }
    }

    void createMapping() {
        int nHoles = this._element.max() - this._element.min() + 1 - this._element.size();
        this._m = this._index.size() == this._element.size() && nHoles < 2000 ? new OneToOneMapping(this._index, this._element, this._ary) : new SimpleMapping(this._index, this._element, this._ary);
    }

    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._element.detachObserver(observer);
    }

    public String domainToString() {
        return this._element.domainToString();
    }

    int[] elementDomain() {
        int[] values = new int[this._index.size()];
        int dst = 0;
        for (int src = 0; src < this._ary.size(); ++src) {
            if (!this._index.contains(src)) continue;
            values[dst++] = this._ary.get(src);
        }
        return IntCalc.differentSortedValues(values);
    }

    public int max() {
        return this._element.max();
    }

    public int min() {
        return this._element.min();
    }

    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._element.reattachObserver(observer);
    }

    public void removeValue(int value) throws Failure {
        this._element.removeValue(value);
    }

    public void setMax(int max) throws Failure {
        this._element.setMax(max);
    }

    public void setMin(int min) throws Failure {
        this._element.setMin(min);
    }

    public void setValue(int value) throws Failure {
        this._element.setValue(value);
    }

    public int size() {
        return this._element.size();
    }

    static final class SimpleMapping
    implements Mapping {
        IntExp _index;
        IntExp _element;
        IntArray _ary;

        public SimpleMapping(IntExp index, IntExp element, IntArray ary) {
            this._index = index;
            this._element = element;
            this._ary = ary;
        }

        public void removeFromElement(int value) throws Failure {
            RemoveFromElementIterator it = RemoveFromElementIterator.getIterator(this._index, this._ary, value, value);
            this._index.iterateDomain(it);
            it.free();
        }

        public void removeFromElement(int min, int max) throws Failure {
            RemoveFromElementIterator it = RemoveFromElementIterator.getIterator(this._index, this._ary, min, max);
            this._index.iterateDomain(it);
            it.free();
        }

        public void removeFromIndex(int idx) throws Failure {
            int value = this._ary.elementAt(idx);
            if (!IntExpElementAt.indexHasValue(this._index, this._ary, value)) {
                this._element.removeValue(value);
            }
        }

        public void removeFromIndex(int min, int max) throws Failure {
            for (int i = min; i <= max; ++i) {
                this.removeFromIndex(i);
            }
        }

        public void setValueFromElement(int value) throws Failure {
            if (this._index.bound()) {
                if (this._ary.elementAt(this._index.valueUnsafe()) != value) {
                    throw new Failure("Value in ElementAt");
                }
                return;
            }
            SetValueFromElementIterator it = SetValueFromElementIterator.getIterator(this._index, this._ary, value);
            this._index.iterateDomain(it);
            it.free();
        }

        public void setValueFromIndex(int idx) throws Failure {
            int value = this._ary.elementAt(idx);
            this._element.setValue(value);
        }
    }

    static class SetValueFromElementIterator
    extends ReusableImpl
    implements IntExp.IntDomainIterator {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new SetValueFromElementIterator();
            }
        };
        IntExp index;
        IntArray ary;
        int value;

        SetValueFromElementIterator() {
        }

        static SetValueFromElementIterator getIterator(IntExp index, IntArray ary, int value) {
            SetValueFromElementIterator it = (SetValueFromElementIterator)_factory.getElement();
            it.index = index;
            it.ary = ary;
            it.value = value;
            return it;
        }

        public boolean doSomethingOrStop(int idx) throws Failure {
            if (this.ary.elementAt(idx) != this.value) {
                this.index.removeValue(idx);
            }
            return true;
        }
    }

    static class RemoveFromElementIterator
    extends ReusableImpl
    implements IntExp.IntDomainIterator {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new RemoveFromElementIterator();
            }
        };
        IntExp index;
        IntArray ary;
        int min;
        int max;

        RemoveFromElementIterator() {
        }

        static RemoveFromElementIterator getIterator(IntExp index, IntArray ary, int min, int max) {
            RemoveFromElementIterator it = (RemoveFromElementIterator)_factory.getElement();
            it.index = index;
            it.ary = ary;
            it.min = min;
            it.max = max;
            return it;
        }

        public boolean doSomethingOrStop(int idx) throws Failure {
            int elementValue = this.ary.elementAt(idx);
            if (this.min <= elementValue && elementValue <= this.max) {
                this.index.removeValue(idx);
            }
            return true;
        }
    }

    static final class OneToOneMapping
    implements Mapping {
        IntExp _index;
        IntExp _element;
        IntArray _ary;
        int[] _element2index;
        int _elementMin;

        public OneToOneMapping(IntExp index, IntExp element, IntArray ary) {
            this._index = index;
            this._element = element;
            this._ary = ary;
            this.createElement2Index();
        }

        void createElement2Index() {
            IntExp.IntDomainIterator it = new IntExp.IntDomainIterator(){

                public boolean doSomethingOrStop(int idx) throws Failure {
                    int elementValue = OneToOneMapping.this._ary.elementAt(idx);
                    OneToOneMapping.this._element2index[elementValue - OneToOneMapping.this._elementMin] = idx;
                    return true;
                }
            };
            this._elementMin = this._element.min();
            int length = this._element.max() - this._elementMin + 1;
            this._element2index = new int[length];
            for (int i = 0; i < length; ++i) {
                this._element2index[i] = -1;
            }
            try {
                this._index.iterateDomain(it);
            }
            catch (Failure failure) {
                // empty catch block
            }
        }

        public void removeFromElement(int value) throws Failure {
            int idx = this._element2index[value - this._elementMin];
            this._index.removeValue(idx);
        }

        public void removeFromElement(int min, int max) throws Failure {
            for (int i = min; i <= max; ++i) {
                int idx = this._element2index[i - this._elementMin];
                if (idx < 0) continue;
                this._index.removeValue(idx);
            }
        }

        public void removeFromIndex(int idx) throws Failure {
            int value = this._ary.elementAt(idx);
            this._element.removeValue(value);
        }

        public void removeFromIndex(int min, int max) throws Failure {
            for (int i = min; i <= max; ++i) {
                this.removeFromIndex(i);
            }
        }

        public void setValueFromElement(int value) throws Failure {
            int idx = this._element2index[value - this._elementMin];
            this._index.setValue(idx);
        }

        public void setValueFromIndex(int idx) throws Failure {
            int value = this._ary.elementAt(idx);
            this._element.setValue(value);
        }
    }

    static interface Mapping {
        public void removeFromElement(int var1) throws Failure;

        public void removeFromElement(int var1, int var2) throws Failure;

        public void removeFromIndex(int var1) throws Failure;

        public void removeFromIndex(int var1, int var2) throws Failure;

        public void setValueFromElement(int var1) throws Failure;

        public void setValueFromIndex(int var1) throws Failure;
    }

    class IndexObserver
    extends Observer {
        IndexObserver() {
        }

        public Object master() {
            return IntExpElementAt.this;
        }

        public int subscriberMask() {
            return 1;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            int type = e.type();
            if ((type & 1) != 0) {
                IntExpElementAt.this._m.setValueFromIndex(e.min());
            } else {
                if ((type & 2) != 0) {
                    IntExpElementAt.this._m.removeFromIndex(e.oldmin(), e.min() - 1);
                }
                if ((type & 4) != 0) {
                    IntExpElementAt.this._m.removeFromIndex(e.max() + 1, e.oldmax());
                }
                if ((type & 8) != 0) {
                    int nRemoves = e.numberOfRemoves();
                    int min = e.min();
                    int max = e.max();
                    for (int i = 0; i < nRemoves; ++i) {
                        int removedValue = e.removed(i);
                        if (min > removedValue || removedValue > max) continue;
                        IntExpElementAt.this._m.removeFromIndex(removedValue);
                    }
                }
            }
        }
    }

    static class FindValueIterator
    extends ReusableImpl
    implements IntExp.IntDomainIterator {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new FindValueIterator();
            }
        };
        IntExp index;
        IntArray ary;
        int value;
        int foundIndex;

        FindValueIterator() {
        }

        static FindValueIterator getIterator(IntExp index, IntArray ary, int value) {
            FindValueIterator it = (FindValueIterator)_factory.getElement();
            it.index = index;
            it.ary = ary;
            it.value = value;
            it.foundIndex = -1;
            return it;
        }

        public boolean doSomethingOrStop(int idx) throws Failure {
            if (this.ary.elementAt(idx) == this.value) {
                this.foundIndex = idx;
                return false;
            }
            return true;
        }
    }

    class ElementObserver
    extends Observer {
        ElementObserver() {
        }

        public Object master() {
            return IntExpElementAt.this;
        }

        public int subscriberMask() {
            return 1;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            int type = e.type();
            if ((type & 1) != 0) {
                IntExpElementAt.this._m.setValueFromElement(e.min());
            } else {
                if ((type & 2) != 0) {
                    IntExpElementAt.this._m.removeFromElement(e.oldmin(), e.min() - 1);
                }
                if ((type & 4) != 0) {
                    IntExpElementAt.this._m.removeFromElement(e.max() + 1, e.oldmax());
                }
                if ((type & 8) != 0) {
                    int nRemoves = e.numberOfRemoves();
                    int min = e.min();
                    int max = e.max();
                    for (int i = 0; i < nRemoves; ++i) {
                        int removedValue = e.removed(i);
                        if (min > removedValue || removedValue > max) continue;
                        IntExpElementAt.this._m.removeFromElement(removedValue);
                    }
                }
            }
        }
    }
}

