/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntCalc;
import org.openl.ie.constrainer.impl.IntExpImpl;

public final class IntExpMulExp
extends IntExpImpl {
    private IntExp _exp1;
    private IntExp _exp2;
    private Observer _observer;
    private IntVar _product;
    private IntExpMulExpCalc _calc;

    public IntExpMulExp(IntExp exp1, IntExp exp2) {
        super(exp1.constrainer());
        this._exp1 = exp1;
        this._exp2 = exp2;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp1.name() + "*" + exp2.name() + ")";
        }
        this.createCalc();
        this._calc.createProduct();
        this._observer = new IntExpMulExpObserver();
        this._exp1.attachObserver(this._observer);
        this._exp2.attachObserver(this._observer);
    }

    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._product.attachObserver(observer);
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        if (this._exp1.bound()) {
            return this._exp2.calcCoeffs(map, factor * (double)this._exp1.max());
        }
        if (this._exp2.bound()) {
            return this._exp1.calcCoeffs(map, factor * (double)this._exp2.max());
        }
        throw new NonLinearExpression(this);
    }

    void createCalc() {
        this._calc = this._exp1.min() >= 0 ? (this._exp2.min() >= 0 ? new CalcPP(this._exp1, this._exp2) : (this._exp2.max() <= 0 ? new CalcPN(this._exp1, this._exp2) : new CalcP(this._exp1, this._exp2))) : (this._exp1.max() <= 0 ? (this._exp2.min() >= 0 ? new CalcPN(this._exp2, this._exp1) : (this._exp2.max() <= 0 ? new CalcNN(this._exp1, this._exp2) : new CalcN(this._exp1, this._exp2))) : (this._exp2.min() >= 0 ? new CalcP(this._exp2, this._exp1) : (this._exp2.max() <= 0 ? new CalcN(this._exp2, this._exp1) : new CalcGeneral(this._exp1, this._exp2))));
    }

    void createProductVar(int min, int max) {
        int trace = 0;
        this._product = this.constrainer().addIntVarTraceInternal(min, max, this._name, 0, trace);
    }

    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._product.detachObserver(observer);
    }

    public boolean isLinear() {
        if (!this._exp1.bound() && !this._exp2.bound()) {
            return false;
        }
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    public int max() {
        return this._product.max();
    }

    public int min() {
        return this._product.min();
    }

    public void name(String name) {
        super.name(name);
        this._product.name(name);
    }

    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._product.reattachObserver(observer);
    }

    public void setMax(int max) throws Failure {
        if (max >= this.max()) {
            return;
        }
        this._product.setMax(max);
        this._calc.setMax(max);
    }

    public void setMin(int min) throws Failure {
        if (min <= this.min()) {
            return;
        }
        this._product.setMin(min);
        this._calc.setMin(min);
    }

    public void setValue(int value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    void updateProductVar(int min, int max) throws Failure {
        this._product.setMin(min);
        this._product.setMax(max);
    }

    class IntExpMulExpObserver
    extends Observer {
        IntExpMulExpObserver() {
        }

        public Object master() {
            return IntExpMulExp.this;
        }

        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "IntExpMulExpObserver: " + IntExpMulExp.this._exp1 + " x " + IntExpMulExp.this._exp2;
        }

        public void update(Subject subject, EventOfInterest event) throws Failure {
            IntExpMulExp.this._calc.updateFromObserver();
        }
    }

    abstract class IntExpMulExpCalc {
        IntExpMulExpCalc() {
        }

        public void createProduct() {
            IntExpMulExp.this.createProductVar(this.min(), this.max());
        }

        public abstract int max();

        public abstract int min();

        public abstract void setMax(int var1) throws Failure;

        public abstract void setMin(int var1) throws Failure;

        public void updateFromObserver() throws Failure {
            IntExpMulExp.this.updateProductVar(this.min(), this.max());
        }
    }

    final class CalcPP
    extends IntExpMulExpCalc {
        private IntExp _exp1;
        private IntExp _exp2;

        public CalcPP(IntExp exp1, IntExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        public int max() {
            return this._exp1.max() * this._exp2.max();
        }

        public int min() {
            return this._exp1.min() * this._exp2.min();
        }

        public void setMax(int max) throws Failure {
            IntCalc.productSetMaxP(max, this._exp1.min(), this._exp1.max(), this._exp2);
            IntCalc.productSetMaxP(max, this._exp2.min(), this._exp2.max(), this._exp1);
        }

        public void setMin(int min) throws Failure {
            IntCalc.productSetMinP(min, this._exp1.min(), this._exp1.max(), this._exp2);
            IntCalc.productSetMinP(min, this._exp2.min(), this._exp2.max(), this._exp1);
        }
    }

    final class CalcPN
    extends IntExpMulExpCalc {
        private IntExp _exp1;
        private IntExp _exp2;

        public CalcPN(IntExp exp1, IntExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        public int max() {
            return this._exp1.min() * this._exp2.max();
        }

        public int min() {
            return this._exp1.max() * this._exp2.min();
        }

        public void setMax(int max) throws Failure {
            IntCalc.productSetMaxP(max, this._exp1.min(), this._exp1.max(), this._exp2);
            IntCalc.productSetMaxN(max, this._exp2.min(), this._exp2.max(), this._exp1);
        }

        public void setMin(int min) throws Failure {
            IntCalc.productSetMinP(min, this._exp1.min(), this._exp1.max(), this._exp2);
            IntCalc.productSetMinN(min, this._exp2.min(), this._exp2.max(), this._exp1);
        }
    }

    final class CalcP
    extends IntExpMulExpCalc {
        private IntExp _exp1;
        private IntExp _exp2;

        public CalcP(IntExp exp1, IntExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        public void createProduct() {
            int min1 = this._exp1.min();
            int max1 = this._exp1.max();
            int min2 = this._exp2.min();
            int max2 = this._exp2.max();
            int min = IntCalc.productMinP(min1, max1, min2);
            int max = IntCalc.productMaxP(min1, max1, max2);
            IntExpMulExp.this.createProductVar(min, max);
        }

        public int max() {
            return IntCalc.productMaxP(this._exp1.min(), this._exp1.max(), this._exp2.max());
        }

        public int min() {
            return IntCalc.productMinP(this._exp1.min(), this._exp1.max(), this._exp2.min());
        }

        public void setMax(int max) throws Failure {
            int min1 = this._exp1.min();
            int max1 = this._exp1.max();
            IntCalc.productSetMaxP(max, min1, max1, this._exp2);
            IntCalc.productSetMax(max, this._exp2, this._exp1);
        }

        public void setMin(int min) throws Failure {
            int min1 = this._exp1.min();
            int max1 = this._exp1.max();
            IntCalc.productSetMinP(min, min1, max1, this._exp2);
            IntCalc.productSetMin(min, this._exp2, this._exp1);
        }

        public void updateFromObserver() throws Failure {
            int min1 = this._exp1.min();
            int max1 = this._exp1.max();
            int min2 = this._exp2.min();
            int max2 = this._exp2.max();
            int min = IntCalc.productMinP(min1, max1, min2);
            int max = IntCalc.productMaxP(min1, max1, max2);
            IntExpMulExp.this.updateProductVar(min, max);
        }
    }

    final class CalcNN
    extends IntExpMulExpCalc {
        private IntExp _exp1;
        private IntExp _exp2;

        public CalcNN(IntExp exp1, IntExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        public int max() {
            return this._exp1.min() * this._exp2.min();
        }

        public int min() {
            return this._exp1.max() * this._exp2.max();
        }

        public void setMax(int max) throws Failure {
            IntCalc.productSetMaxN(max, this._exp1.min(), this._exp1.max(), this._exp2);
            IntCalc.productSetMaxN(max, this._exp2.min(), this._exp2.max(), this._exp1);
        }

        public void setMin(int min) throws Failure {
            IntCalc.productSetMinN(min, this._exp1.min(), this._exp1.max(), this._exp2);
            IntCalc.productSetMinN(min, this._exp2.min(), this._exp2.max(), this._exp1);
        }
    }

    final class CalcN
    extends IntExpMulExpCalc {
        private IntExp _exp1;
        private IntExp _exp2;

        public CalcN(IntExp exp1, IntExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        public void createProduct() {
            int min1 = this._exp1.min();
            int max1 = this._exp1.max();
            int min2 = this._exp2.min();
            int max2 = this._exp2.max();
            int min = IntCalc.productMinN(min1, max1, max2);
            int max = IntCalc.productMaxN(min1, max1, min2);
            IntExpMulExp.this.createProductVar(min, max);
        }

        public int max() {
            return IntCalc.productMaxN(this._exp1.min(), this._exp1.max(), this._exp2.min());
        }

        public int min() {
            return IntCalc.productMinN(this._exp1.min(), this._exp1.max(), this._exp2.max());
        }

        public void setMax(int max) throws Failure {
            int min1 = this._exp1.min();
            int max1 = this._exp1.max();
            IntCalc.productSetMaxN(max, min1, max1, this._exp2);
            IntCalc.productSetMax(max, this._exp2, this._exp1);
        }

        public void setMin(int min) throws Failure {
            int min1 = this._exp1.min();
            int max1 = this._exp1.max();
            IntCalc.productSetMinN(min, min1, max1, this._exp2);
            IntCalc.productSetMin(min, this._exp2, this._exp1);
        }

        public void updateFromObserver() throws Failure {
            int min1 = this._exp1.min();
            int max1 = this._exp1.max();
            int min2 = this._exp2.min();
            int max2 = this._exp2.max();
            int min = IntCalc.productMinN(min1, max1, max2);
            int max = IntCalc.productMaxN(min1, max1, min2);
            IntExpMulExp.this.updateProductVar(min, max);
        }
    }

    final class CalcGeneral
    extends IntExpMulExpCalc {
        private IntExp _exp1;
        private IntExp _exp2;

        public CalcGeneral(IntExp exp1, IntExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        public void createProduct() {
            int min1 = this._exp1.min();
            int max1 = this._exp1.max();
            int min2 = this._exp2.min();
            int max2 = this._exp2.max();
            int min = IntCalc.productMin(min1, max1, min2, max2);
            int max = IntCalc.productMax(min1, max1, min2, max2);
            IntExpMulExp.this.createProductVar(min, max);
        }

        public int max() {
            return IntCalc.productMax(this._exp1.min(), this._exp1.max(), this._exp2.min(), this._exp2.max());
        }

        public int min() {
            return IntCalc.productMin(this._exp1.min(), this._exp1.max(), this._exp2.min(), this._exp2.max());
        }

        public void setMax(int max) throws Failure {
            IntCalc.productSetMax(max, this._exp1, this._exp2);
            IntCalc.productSetMax(max, this._exp2, this._exp1);
        }

        public void setMin(int min) throws Failure {
            IntCalc.productSetMin(min, this._exp1, this._exp2);
            IntCalc.productSetMin(min, this._exp2, this._exp1);
        }

        public void updateFromObserver() throws Failure {
            int min1 = this._exp1.min();
            int max1 = this._exp1.max();
            int min2 = this._exp2.min();
            int max2 = this._exp2.max();
            int min = IntCalc.productMin(min1, max1, min2, max2);
            int max = IntCalc.productMax(min1, max1, min2, max2);
            IntExpMulExp.this.updateProductVar(min, max);
        }
    }
}

