/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalGenerate;
import org.openl.ie.constrainer.IntBoolVar;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.IntSetVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.UndoImpl;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntSetEvent;
import org.openl.ie.constrainer.impl.SubjectImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public class IntSetVarImpl
extends SubjectImpl
implements IntSetVar {
    private IntExpArray _set;
    private HashMap _values2index = new HashMap();
    private int _unboundsCounter;

    private IntSetVarImpl(Constrainer C) {
        super(C);
    }

    public IntSetVarImpl(Constrainer C, int[] array) {
        this(C, array, "");
    }

    public IntSetVarImpl(Constrainer C, int[] array, String name) {
        super(C, name);
        int size = array.length;
        this._set = new IntExpArray(C, size);
        for (int i = 0; i < size; ++i) {
            this._set.set(C.addIntBoolVarInternal(this.name() + "[" + array[i] + "]"), i);
            this._set.get(i).attachObserver(new ElementsObserver(array[i]));
            this._values2index.put(new Integer(array[i]), new Integer(i));
        }
        this._unboundsCounter = size;
    }

    public boolean bound() {
        for (int i = 0; i < this._set.size(); ++i) {
            if (this._set.get(i).bound()) continue;
            return false;
        }
        return true;
    }

    public IntExp cardinality() {
        return this._set.sum();
    }

    public boolean contains(Set anotherSet) {
        if (!this._values2index.keySet().containsAll(anotherSet)) {
            return false;
        }
        Iterator iter = anotherSet.iterator();
        while (iter.hasNext()) {
            int val = (Integer)iter.next();
            if (this.possible(val)) continue;
            return false;
        }
        return true;
    }

    public Goal generate() {
        return new GoalGenerate(this._set);
    }

    private IntBoolVar hasElem(int i) {
        int idx = (Integer)this._values2index.get(new Integer(i));
        return (IntBoolVar)this._set.get(idx);
    }

    public IntSetVar intersectionWith(IntSetVar anotherSet) {
        if (anotherSet instanceof IntSetVarImpl) {
            return this.intersectionWith((IntSetVarImpl)anotherSet);
        }
        return anotherSet.intersectionWith(this);
    }

    public IntSetVar intersectionWith(IntSetVarImpl anotherSet) {
        Set values1 = anotherSet._values2index.keySet();
        Set values2 = this._values2index.keySet();
        int[] tmp = new int[values1.size()];
        Iterator iter = values1.iterator();
        int counter = 0;
        while (iter.hasNext()) {
            Integer curValue = (Integer)iter.next();
            if (!values2.contains(curValue)) continue;
            tmp[counter++] = curValue;
        }
        int[] intersection = new int[counter];
        System.arraycopy(tmp, 0, intersection, 0, counter);
        IntSetVarImpl result = (IntSetVarImpl)this.constrainer().addIntSetVar(intersection);
        for (int i = 0; i < intersection.length; ++i) {
            int val = intersection[i];
            try {
                result.hasElem(val).equals(this.hasElem(val).and(anotherSet.hasElem(val))).execute();
                continue;
            }
            catch (Failure f) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isPossible(int val) {
        if (!this._values2index.keySet().contains(new Integer(val))) {
            return false;
        }
        return this.hasElem(val).max() == 1;
    }

    public Constraint nullIntersectWith(IntSetVar anotherVar) {
        return this.intersectionWith(anotherVar).cardinality().equals(0);
    }

    public boolean possible(int value) {
        return this.hasElem(value).max() == 1;
    }

    public Set possibleSet() {
        HashSet<Integer> values = new HashSet<Integer>();
        for (Integer curValue : this._values2index.keySet()) {
            if (this.hasElem(curValue).max() != 1) continue;
            values.add(curValue);
        }
        return values;
    }

    public void propagate() throws Failure {
    }

    public void remove(int val) throws Failure {
        this.hasElem(val).setFalse();
    }

    public void require(int val) throws Failure {
        this.hasElem(val).setTrue();
    }

    public boolean required(int value) {
        return this.hasElem(value).min() == 1;
    }

    public Set requiredSet() {
        HashSet<Integer> values = new HashSet<Integer>();
        for (Integer curValue : this._values2index.keySet()) {
            if (this.hasElem(curValue).min() != 1) continue;
            values.add(curValue);
        }
        return values;
    }

    public IntSetVar unionWith(IntSetVar anotherSet) {
        if (anotherSet instanceof IntSetVarImpl) {
            return this.unionWith((IntSetVarImpl)anotherSet);
        }
        return anotherSet.unionWith(this);
    }

    public IntSetVar unionWith(IntSetVarImpl anotherSet) {
        Set values1 = this._values2index.keySet();
        Set values2 = anotherSet._values2index.keySet();
        int[] tmp = new int[values1.size() + values2.size()];
        int counter = 0;
        Iterator iter = values1.iterator();
        while (iter.hasNext()) {
            tmp[counter++] = (Integer)iter.next();
        }
        for (Integer curValue : values2) {
            if (values1.contains(curValue)) continue;
            tmp[counter++] = curValue;
        }
        int[] union = new int[counter];
        System.arraycopy(tmp, 0, union, 0, counter);
        IntSetVarImpl result = (IntSetVarImpl)this.constrainer().addIntSetVar(union);
        for (int i = 0; i < union.length; ++i) {
            int val = union[i];
            if (values1.contains(new Integer(val))) {
                if (values2.contains(new Integer(val))) {
                    try {
                        result.hasElem(val).equals(this.hasElem(val).or(anotherSet.hasElem(val))).execute();
                    }
                    catch (Failure f) {}
                    continue;
                }
                try {
                    result.hasElem(val).equals(this.hasElem(val)).execute();
                }
                catch (Failure f) {}
                continue;
            }
            try {
                result.hasElem(val).equals(anotherSet.hasElem(val)).execute();
                continue;
            }
            catch (Failure f) {
                // empty catch block
            }
        }
        return result;
    }

    public Set value() throws Failure {
        if (!this.bound()) {
            this.constrainer().fail("Attempt to get value of the unbound variable " + this);
        }
        return this.requiredSet();
    }

    public static class UndoPossibleSetReduction
    extends UndoImpl {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new UndoPossibleSetReduction();
            }
        };

        static UndoPossibleSetReduction getUndo(IntSetVarImpl var) {
            UndoPossibleSetReduction undo = (UndoPossibleSetReduction)_factory.getElement();
            undo.undoable(var);
            return undo;
        }

        public String toString() {
            return "UndoPossibleSetReduction " + this.undoable();
        }

        public void undo() {
            IntSetVarImpl var = (IntSetVarImpl)this.undoable();
            var._unboundsCounter++;
            super.undo();
        }
    }

    class ElementsObserver
    extends Observer {
        private int _val;

        public ElementsObserver(int val) {
            this._val = val;
        }

        public Object master() {
            return IntSetVarImpl.this;
        }

        public int subscriberMask() {
            return 15;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntSetVarImpl.this.constrainer().addUndo(UndoPossibleSetReduction.getUndo(IntSetVarImpl.this));
            IntSetVarImpl.this._unboundsCounter--;
            IntEvent e = (IntEvent)event;
            int valueMask = 0;
            if (IntSetVarImpl.this._unboundsCounter == 0) {
                valueMask = 4;
            }
            if (e.max() == 1) {
                IntSetVarImpl.this.notifyObservers(IntSetEvent.getEvent(IntSetVarImpl.this, this._val, 2 | valueMask));
            } else {
                IntSetVarImpl.this.notifyObservers(IntSetEvent.getEvent(IntSetVarImpl.this, this._val, 1 | valueMask));
            }
        }
    }
}

