/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.io.Serializable;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Undo;
import org.openl.ie.tools.FastStack;

public final class UndoStack
implements Serializable {
    private FastStack _stack = new FastStack();

    public void backtrack(int newSize) {
        int size = this._stack.size();
        if (newSize > size) {
            Constrainer.abort("Internal error in UndoStack.backtrack(): newSize > size");
        }
        int nUndos = size - newSize;
        while (nUndos-- > 0) {
            Undo undo_object = this.popUndo();
            undo_object.undo();
        }
    }

    public boolean empty() {
        return this._stack.empty();
    }

    Undo popUndo() {
        return (Undo)this._stack.pop();
    }

    public void pushUndo(Undo undo) {
        this._stack.push(undo);
    }

    public int size() {
        return this._stack.size();
    }

    public String toString() {
        return "UndoStack: " + this._stack;
    }
}

