/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.lpsolver;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.ConstrainerObject;
import org.openl.ie.constrainer.ConstrainerObjectImpl;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatExpArray;

public class FloatExpTable
extends ConstrainerObjectImpl
implements ConstrainerObject {
    protected FloatExpArray _array;
    protected int _nbRows;
    protected int _nbCols;

    public FloatExpTable(Constrainer c, int nbRows, int nbCols) {
        this(c, nbRows, nbCols, "");
    }

    public FloatExpTable(Constrainer c, int nbRows, int nbCols, String name) {
        super(c, name);
        this._array = new FloatExpArray(c, nbRows * nbCols);
        this._nbRows = nbRows;
        this._nbCols = nbCols;
    }

    public FloatExp elementAt(int m, int n) {
        return this._array.elementAt(m * this._nbCols + n);
    }

    public FloatExp get(int m, int n) {
        return this._array.get(m * this._nbCols + n);
    }

    public FloatExpArray getColumn(int n) {
        if (n >= this._nbCols) {
            throw new IndexOutOfBoundsException();
        }
        FloatExpArray arr = new FloatExpArray(this._array.constrainer(), this._nbRows);
        FloatExp[] source = this._array.data();
        FloatExp[] dest = arr.data();
        int start = n;
        int end = this._nbCols * (this._nbRows - 1) + n;
        int step = this._nbCols;
        int counter = 0;
        for (int i = start; i <= end; i += step) {
            dest[counter] = source[i];
            ++counter;
        }
        return arr;
    }

    public FloatExpArray getRow(int m) {
        if (m >= this._nbRows) {
            throw new IndexOutOfBoundsException();
        }
        FloatExpArray arr = new FloatExpArray(this._array.constrainer(), this._nbCols);
        FloatExp[] source = this._array.data();
        FloatExp[] dest = arr.data();
        int start = m * this._nbCols;
        int end = m * this._nbCols + this._nbCols;
        System.arraycopy(source, start, dest, 0, end - start);
        return arr;
    }

    public double max() {
        return this._array.max();
    }

    public double min() {
        return this._array.min();
    }

    public FloatExpArray mul(double[] vec) {
        if (this._nbCols != vec.length) {
            throw new IllegalArgumentException("Incorrect vector length (must be equal to the number of columns)");
        }
        FloatExpArray arr = new FloatExpArray(this.constrainer(), this._nbRows);
        for (int i = 0; i < arr.size(); ++i) {
            arr.set(this.constrainer().scalarProduct(this.getRow(i), vec), i);
        }
        return arr;
    }

    public void set(FloatExp exp, int m, int n) {
        this._array.set(exp, m * this._nbCols + n);
    }

    public FloatExp sum() {
        return this._array.sum();
    }

    public FloatExpArray toFloatExpArray() {
        return this._array;
    }
}

