/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.lpsolver.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.ConstrainerObjectImpl;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.lpsolver.ConstrainerMIP;
import org.openl.ie.constrainer.lpsolver.LPConstraint;
import org.openl.ie.constrainer.lpsolver.UnexpectedVariable;
import org.openl.ie.exigensimplex.MatrixRow;
import org.openl.ie.exigensimplex.VarBounds;

public class LPIntegerProblemImpl
extends ConstrainerObjectImpl
implements ConstrainerMIP {
    private Vector _cost = new Vector();
    private Vector _ctType = new Vector();
    private Vector _constraints = new Vector();
    private HashMap _vars_locs = new HashMap();
    private HashMap _locs_vars = null;
    private double _freeTerm = 0.0;
    private boolean _maximiz = false;

    public LPIntegerProblemImpl(IntExp exp, boolean maximization) throws NonLinearExpression {
        this(exp, maximization, exp.constrainer(), "");
    }

    public LPIntegerProblemImpl(IntExp exp, boolean maximization, Constrainer c, String name) throws NonLinearExpression {
        super(c, name);
        if (!exp.isLinear()) {
            throw new NonLinearExpression(exp);
        }
        HashMap map = new HashMap();
        this._freeTerm = exp.calcCoeffs(map);
        Iterator iter = map.keySet().iterator();
        int varCounter = 0;
        while (iter.hasNext()) {
            IntExp curExp = (IntExp)iter.next();
            this._vars_locs.put(curExp, new Integer(varCounter));
            this._cost.add(map.get(curExp));
            ++varCounter;
        }
        this._maximiz = maximization;
    }

    public LPIntegerProblemImpl(IntExpArray array, double[] costCoeffs, boolean maximization) throws NonLinearExpression {
        this(array, costCoeffs, maximization, array.constrainer(), "");
    }

    public LPIntegerProblemImpl(IntExpArray array, double[] costCoeffs, boolean maximization, Constrainer c, String name) throws NonLinearExpression {
        super(c, name);
        if (array.size() != costCoeffs.length) {
            throw new IllegalArgumentException("Array of variables and array of their coefficients must be of the same size");
        }
        for (int i = 0; i < array.size(); ++i) {
            IntExp curExp = array.get(i);
            if (!curExp.isLinear()) {
                throw new NonLinearExpression(curExp);
            }
            this._vars_locs.put(curExp, new Integer(i));
            this._cost.set(i, new Double(costCoeffs[i]));
        }
        this._maximiz = maximization;
    }

    public void addConstraint(IntBoolExp exp, boolean isEquality) throws NonLinearExpression {
        if (!exp.isLinear()) {
            throw new NonLinearExpression(exp);
        }
        this._constraints.add(exp);
        this._ctType.add(new Boolean(isEquality));
    }

    public void addConstraints(Collection exps, boolean isEquality) throws NonLinearExpression {
        Iterator iter = exps.iterator();
        while (iter.hasNext()) {
            this.addConstraint((IntBoolExp)iter.next(), isEquality);
        }
    }

    public void addVar(IntVar var) {
        int num = this._vars_locs.size();
        this._vars_locs.put(var, new Integer(num));
        if (this._locs_vars != null) {
            this._locs_vars.put(new Integer(num), var);
        }
        this._cost.add(new Double(0.0));
    }

    public IntBoolExp[] constraints() {
        IntBoolExp[] constrs = new IntBoolExp[this._constraints.size()];
        this._constraints.toArray(constrs);
        return constrs;
    }

    public IntBoolExp getConstraint(int idx) {
        return (IntBoolExp)this._constraints.get(idx);
    }

    public double getCostCoeff(int idx) {
        return (Double)this._cost.get(idx);
    }

    public double getFreeTerm() {
        return this._freeTerm;
    }

    public LPConstraint getLPConstraint(int i) throws UnexpectedVariable {
        return this.parseBoolExp((IntBoolExp)this._constraints.get(i), i);
    }

    public IntVar getVar(int idx) {
        if (this._locs_vars == null) {
            this._locs_vars = new HashMap();
            for (IntVar var : this._vars_locs.keySet()) {
                Integer num = (Integer)this._vars_locs.get(var);
                this._locs_vars.put(num, var);
            }
        }
        return (IntVar)this._locs_vars.get(new Integer(idx));
    }

    public boolean isEquality(int idx) {
        return (Boolean)this._ctType.get(idx);
    }

    public LPConstraint[] lpConstraints() throws UnexpectedVariable {
        LPConstraint[] constrs = new LPConstraint[this._constraints.size()];
        for (int i = 0; i < this._constraints.size(); ++i) {
            constrs[i] = this.parseBoolExp((IntBoolExp)this._constraints.get(i), i);
        }
        return constrs;
    }

    public int nbConstraints() {
        return this._constraints.size();
    }

    public int nbVars() {
        return this._vars_locs.size();
    }

    private LPConstraint parseBoolExp(IntBoolExp exp, int idx) throws UnexpectedVariable {
        double frTrm;
        if (exp == null) {
            return null;
        }
        HashMap map = new HashMap();
        try {
            frTrm = exp.calcCoeffs(map);
        }
        catch (Exception e) {
            return null;
        }
        int[] pre_pos = new int[map.size()];
        double[] pre_vals = new double[map.size()];
        Iterator iter = map.keySet().iterator();
        Set varSet = this._vars_locs.keySet();
        int varCounter = 0;
        while (iter.hasNext()) {
            int varPos;
            IntExp curExp = (IntExp)iter.next();
            double factor = (Double)map.get(curExp);
            if (factor == 0.0) continue;
            if (!varSet.contains(curExp)) {
                if (!curExp.bound()) {
                    throw new UnexpectedVariable(curExp);
                }
                try {
                    frTrm += (double)curExp.value() * factor;
                }
                catch (Failure f) {}
                continue;
            }
            pre_pos[varCounter] = varPos = ((Integer)this._vars_locs.get(curExp)).intValue();
            pre_vals[varCounter] = factor;
            ++varCounter;
        }
        boolean isEquality = (Boolean)this._ctType.get(idx);
        int type = isEquality ? 4 : 1;
        LPConstraintImpl constraint = null;
        if (varCounter < pre_pos.length) {
            int[] pos = new int[varCounter];
            double[] vals = new double[varCounter];
            System.arraycopy(pre_pos, 0, pos, 0, varCounter);
            System.arraycopy(pre_vals, 0, vals, 0, varCounter);
            constraint = new LPConstraintImpl(pos, vals, type, -frTrm);
        } else {
            constraint = new LPConstraintImpl(pre_pos, pre_vals, type, -frTrm);
        }
        return constraint;
    }

    public void removeConstraint(int idx) {
        this._ctType.remove(idx);
        this._constraints.remove(idx);
    }

    public void removeVar(IntVar var) {
        int pos = (Integer)this._vars_locs.get(var);
        this._vars_locs.remove(var);
        if (this._locs_vars != null) {
            this._locs_vars.remove(new Integer(pos));
        }
        this._cost.remove(pos);
    }

    public void setCostCoeff(int idx, double coeff) {
        this._cost.set(idx, new Double(coeff));
    }

    public void setFreeTerm(double frTrm) {
        this._freeTerm = frTrm;
    }

    public boolean toBeMaximized() {
        return this._maximiz;
    }

    public String toString() {
        String str = "[" + this.name() + "\n";
        str = str + "vars:" + this._vars_locs.size() + ", constraints:" + this._constraints.size() + "\n";
        str = str + "vars:\n" + this._vars_locs + "\n";
        str = str + "cost_function:\n" + this._cost + " free term:" + this._freeTerm + "\n";
        str = str + "constraints:\n";
        for (int i = 0; i < this._constraints.size(); ++i) {
            str = str + i + ". ";
            try {
                str = str + this.parseBoolExp((IntBoolExp)this._constraints.get(i), i) + "\n";
                continue;
            }
            catch (UnexpectedVariable uv) {
                str = str + "invalid constraint!";
            }
        }
        str = str + "];";
        return str;
    }

    private class LPConstraintImpl
    implements LPConstraint {
        private MatrixRow _mtrow = null;
        private VarBounds _bnds = null;

        public LPConstraintImpl(int[] locations, double[] values, int type, double lb) {
            this._mtrow = new MatrixRow(locations, values);
            this._bnds = new VarBounds(type, lb, type == 4 ? lb : 2.147483647E9);
        }

        public double getLb() {
            return this._bnds.getLb();
        }

        public int[] getLocations() {
            return this._mtrow.getLocations();
        }

        public int getType() {
            return this._bnds.getType();
        }

        public double getUb() {
            return this._bnds.getUb();
        }

        public double[] getValues() {
            return this._mtrow.getValues();
        }

        public String toString() {
            return "[" + this._bnds.toString() + "," + this._mtrow.toString() + "]";
        }
    }
}

