/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.scheduler;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.scheduler.AlternativeResourceConstraint;
import org.openl.ie.scheduler.AlternativeResourceSet;
import org.openl.ie.scheduler.Job;
import org.openl.ie.scheduler.Resource;
import org.openl.ie.scheduler.Schedule;

public class JobInterval
implements Job {
    private Constrainer _constrainer;
    private Schedule _schedule;
    private IntVar _start;
    private IntVar _end;
    private int _duration;
    private int _s_min;
    private int _e_max;
    private String _name;

    public JobInterval(Schedule sch, int duration) throws Failure {
        this._duration = duration;
        this._schedule = sch;
        this._constrainer = this._schedule.constrainer();
        this._start = this._constrainer.addIntVar(this._schedule.start(), this._schedule.end());
        this._end = this._constrainer.addIntVar(this._schedule.start(), this._schedule.end());
        this._constrainer.postConstraint(this._end.eq(this._start.add(this._duration)));
        this.saveAssignmentInfo();
    }

    public boolean bound() {
        return this._start.bound();
    }

    public Constrainer constrainer() {
        return this._constrainer;
    }

    public int duration() {
        return this._duration;
    }

    public int endMax() {
        return this._end.max();
    }

    public int endMaxA() {
        return this._e_max;
    }

    public IntBoolExp endsAfterEnd(Job job) {
        return job.getEndVariable().le(this._end);
    }

    public IntBoolExp endsAfterStart(Job job) {
        return job.getStartVariable().le(this._end);
    }

    public String getAssignment() {
        return this._schedule.getAssignments(this);
    }

    public IntVar getEndVariable() {
        return this._end;
    }

    public String getName() {
        return this._name;
    }

    public IntVar getStartVariable() {
        return this._start;
    }

    public AlternativeResourceConstraint requires(AlternativeResourceSet res, int capacity) {
        return new AlternativeResourceConstraint((Job)this, res, capacity);
    }

    public AlternativeResourceConstraint requires(AlternativeResourceSet res, IntVar capacity) {
        return new AlternativeResourceConstraint((Job)this, res, capacity);
    }

    public AlternativeResourceConstraint requires(Resource res, int capacity) {
        AlternativeResourceSet set = new AlternativeResourceSet();
        set.add(res);
        return this.requires(set, capacity);
    }

    public AlternativeResourceConstraint requires(Resource res, IntVar capacity) {
        AlternativeResourceSet set = new AlternativeResourceSet();
        set.add(res);
        return this.requires(set, capacity);
    }

    public void saveAssignmentInfo() {
        this._s_min = this._start.min();
        this._e_max = this._end.max();
    }

    public Schedule schedule() {
        return this._schedule;
    }

    public void setName(String name) {
        this._name = name;
        this._start.name(this._name + ".start");
        this._end.name(this._name + ".end");
    }

    public int startMin() {
        return this._start.min();
    }

    public int startMinA() {
        return this._s_min;
    }

    public IntBoolExp startsAfterEnd(Job job) {
        return job.getEndVariable().le(this._start);
    }

    public IntBoolExp startsAfterStart(Job job) {
        return job.getStartVariable().le(this._start);
    }

    public IntBoolExp startsAtStart(Job job) {
        return job.getStartVariable().eq(this._start);
    }

    public String toString() {
        return this.getName() + this.value();
    }

    public String value() {
        try {
            String assignments = this._schedule.getAssignments(this);
            return "[" + this.getStartVariable().value() + " --" + this._duration + "--> " + this.getEndVariable().value() + ")" + (assignments.equalsIgnoreCase("") ? "" : " => " + assignments);
        }
        catch (Failure f) {
            return "[" + this.getStartVariable().domainToString() + " --" + this._duration + "--> " + this.getEndVariable().domainToString() + ")";
        }
    }
}

