/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.simplex;

import org.openl.ie.simplex.Status;

public class MIPErrorCodes {
    public static final int NOT_A_MIP = 3000;
    public static final int LPX_I_UNDEF = MIPErrorCodes.native_LPX_I_UNDEF();
    public static final int LPX_I_OPT = MIPErrorCodes.native_LPX_I_OPT();
    public static final int LPX_I_FEAS = MIPErrorCodes.native_LPX_I_FEAS();
    public static final int LPX_I_NOFEAS = MIPErrorCodes.native_LPX_I_NOFEAS();

    public static boolean isFeasible(int errorCode) {
        return errorCode == LPX_I_OPT || errorCode == LPX_I_FEAS;
    }

    public static boolean isOptimal(int errorCode) {
        return errorCode == LPX_I_OPT;
    }

    private static native int native_LPX_I_FEAS();

    private static native int native_LPX_I_NOFEAS();

    private static native int native_LPX_I_OPT();

    private static native int native_LPX_I_UNDEF();

    private MIPErrorCodes() {
    }

    static {
        Status.dictionary.put(new Integer(LPX_I_UNDEF), "The problem status is undefined");
        Status.dictionary.put(new Integer(LPX_I_OPT), "The solution is integer optimal");
        Status.dictionary.put(new Integer(LPX_I_FEAS), "The solution is integer feasible");
        Status.dictionary.put(new Integer(LPX_I_NOFEAS), "The problem has no integer feasible solution");
        Status.dictionary.put(new Integer(3000), "It is not a MIP kind problem");
    }
}

