/*
 * Decompiled with CFR 0.152.
 */
package org.openl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.openl.util.Log;

public class SmartProps {
    private final Properties props;

    public SmartProps(Properties properties) {
        this.props = (Properties)properties.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmartProps(String fullName) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fullName);
        if (is == null) {
            Log.error((String)"Cannot find resource by name ''{0}''!", (Object[])new Object[]{fullName});
        }
        this.props = new Properties();
        try {
            this.props.load(is);
        }
        catch (IOException e) {
            Log.error((Object)"Failed to load properties!", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.error((Object)"Failed to close InputStream!", (Throwable)e);
            }
        }
    }

    public String getStr(String name) {
        String s = this.props.getProperty(name);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String getStr(String name, String def) {
        String s = this.getStr(name);
        if (s == null || s.length() == 0) {
            s = def;
        }
        return s;
    }
}

