/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace;

import java.util.HashMap;
import java.util.Map;
import org.openl.rules.workspace.WorkspaceException;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.deploy.DeploymentException;
import org.openl.rules.workspace.deploy.ProductionDeployer;
import org.openl.rules.workspace.deploy.ProductionDeployerManager;
import org.openl.rules.workspace.dtr.DesignTimeRepository;
import org.openl.rules.workspace.lw.LocalWorkspace;
import org.openl.rules.workspace.lw.LocalWorkspaceManager;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.rules.workspace.uw.UserWorkspaceListener;
import org.openl.rules.workspace.uw.impl.UserWorkspaceImpl;

public class MultiUserWorkspaceManager
implements UserWorkspaceListener {
    private ProductionDeployerManager productionDeployerManager;
    private DesignTimeRepository designTimeRepository;
    private LocalWorkspaceManager localWorkspaceManager;
    private Map<String, UserWorkspace> userWorkspaces = new HashMap<String, UserWorkspace>();

    protected UserWorkspace createUserWorkspace(WorkspaceUser user) throws WorkspaceException {
        ProductionDeployer deployer;
        LocalWorkspace usersLocalWorkspace = this.localWorkspaceManager.getWorkspace(user);
        try {
            deployer = this.productionDeployerManager.getDeployer(user);
        }
        catch (DeploymentException e) {
            throw new WorkspaceException("can not get production deployer", e);
        }
        return new UserWorkspaceImpl(user, usersLocalWorkspace, this.designTimeRepository, deployer);
    }

    public LocalWorkspaceManager getLocalWorkspaceManager() {
        return this.localWorkspaceManager;
    }

    public UserWorkspace getUserWorkspace(WorkspaceUser user) throws WorkspaceException {
        UserWorkspace uw = this.userWorkspaces.get(user.getUserId());
        if (uw == null) {
            uw = this.createUserWorkspace(user);
            this.userWorkspaces.put(user.getUserId(), uw);
        } else {
            LocalWorkspace usersLocalWorkspace = this.localWorkspaceManager.getWorkspace(user);
            usersLocalWorkspace.setUserWorkspace(uw);
        }
        return uw;
    }

    public void setDesignTimeRepository(DesignTimeRepository designTimeRepository) {
        this.designTimeRepository = designTimeRepository;
    }

    public void setLocalWorkspaceManager(LocalWorkspaceManager localWorkspaceManager) {
        this.localWorkspaceManager = localWorkspaceManager;
    }

    public void setProductionDeployerManager(ProductionDeployerManager productionDeployerManager) {
        this.productionDeployerManager = productionDeployerManager;
    }

    public void workspaceReleased(UserWorkspace workspace) {
        this.userWorkspaces.remove(((UserWorkspaceImpl)workspace).getUser().getUserId());
    }
}

