/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.abstracts.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openl.rules.workspace.abstracts.ArtefactPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtefactPathImpl
implements ArtefactPath {
    public static final char SEGMENT_DELIMITER = '/';
    private String stringValue = null;
    private List<String> segments = new LinkedList<String>();

    public ArtefactPathImpl(ArtefactPath artefactPath) {
        this.segments.addAll(artefactPath.getSegments());
    }

    public ArtefactPathImpl(List<String> segments) {
        for (String element : segments) {
            this.addSegment(element);
        }
    }

    public ArtefactPathImpl(String[] segments) {
        for (String element : segments) {
            this.addSegment(element);
        }
    }

    public ArtefactPathImpl(String pathAsString) {
        if (pathAsString.length() > 0 && pathAsString.charAt(0) == '/') {
            this.appendToSegments(pathAsString.substring(1));
        } else {
            this.appendToSegments(pathAsString);
        }
    }

    protected void addSegment(String segment) {
        if (segment.indexOf(47) >= 0) {
            // empty if block
        }
        this.segments.add(segment);
    }

    protected void appendToSegments(String pathAsString) {
        int len = pathAsString.length();
        int pos = 0;
        int end = 0;
        while (end < len) {
            end = pathAsString.indexOf(47, pos);
            if (end < 0) {
                end = len;
            }
            String s = pathAsString.substring(pos, end);
            this.addSegment(s);
            pos = end + 1;
        }
    }

    protected Object clone() {
        return new ArtefactPathImpl(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ArtefactPathImpl) {
            ArtefactPathImpl other = (ArtefactPathImpl)obj;
            if (this.segmentCount() != other.segmentCount()) {
                return false;
            }
            Iterator<String> it1 = this.segments.iterator();
            Iterator<String> it2 = other.segments.iterator();
            while (it1.hasNext()) {
                if (it1.next().equals(it2.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getSegments() {
        return this.segments;
    }

    @Override
    public String getStringValue() {
        if (this.stringValue == null) {
            StringBuilder result = new StringBuilder();
            result.append('/');
            Iterator<String> i = this.segments.iterator();
            while (i.hasNext()) {
                String segment = i.next();
                result.append(segment);
                if (!i.hasNext()) continue;
                result.append('/');
            }
            this.stringValue = result.toString();
        }
        return this.stringValue;
    }

    @Override
    public String getStringValue(int skip) {
        StringBuilder result = new StringBuilder();
        if (skip < this.segmentCount()) {
            Iterator<String> it = this.segments.iterator();
            while (skip > 0) {
                it.next();
                --skip;
            }
            while (it.hasNext()) {
                result.append('/').append(it.next());
            }
        }
        return result.toString();
    }

    public int hashCode() {
        return this.getStringValue().hashCode();
    }

    @Override
    public String segment(int index) {
        return this.segments.get(index);
    }

    @Override
    public int segmentCount() {
        return this.segments.size();
    }

    @Override
    public ArtefactPath withoutFirstSegment() {
        LinkedList<String> relativeSegments = new LinkedList<String>();
        boolean isFisrt = true;
        for (String s : this.segments) {
            if (isFisrt) {
                isFisrt = false;
                continue;
            }
            relativeSegments.add(s);
        }
        return new ArtefactPathImpl(relativeSegments);
    }

    @Override
    public ArtefactPath withSegment(String segment) {
        ArtefactPathImpl api = new ArtefactPathImpl(this);
        api.addSegment(segment);
        return api;
    }
}

