/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.abstracts.impl;

import org.openl.rules.workspace.abstracts.ProjectDependency;
import org.openl.rules.workspace.abstracts.ProjectVersion;

public class ProjectDependencyImpl
implements ProjectDependency {
    private static final long serialVersionUID = -1745471023092596849L;
    private String projectName;
    private ProjectVersion lowerLimit;
    private ProjectVersion upperLimit;

    public ProjectDependencyImpl(String projectName, ProjectVersion lowerLimit) {
        this(projectName, lowerLimit, null);
    }

    public ProjectDependencyImpl(String projectName, ProjectVersion lowerLimit, ProjectVersion upperLimit) {
        if (projectName == null) {
            throw new NullPointerException("projectName is null");
        }
        if (lowerLimit == null) {
            throw new NullPointerException("lowerLimit is null");
        }
        if (upperLimit != null && lowerLimit.compareTo(upperLimit) > 0) {
            throw new IllegalArgumentException("upperLimit is less than lowerLimit");
        }
        this.projectName = projectName;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectDependencyImpl)) {
            return false;
        }
        ProjectDependencyImpl that = (ProjectDependencyImpl)o;
        return this.projectName.equals(that.projectName) && this.lowerLimit.equals(that.lowerLimit) && (this.upperLimit == null ? that.upperLimit == null : this.upperLimit.equals(that.upperLimit));
    }

    public ProjectVersion getLowerLimit() {
        return this.lowerLimit;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ProjectVersion getUpperLimit() {
        return this.upperLimit;
    }

    public int hashCode() {
        int result = this.projectName.hashCode();
        result = 31 * result + this.lowerLimit.hashCode();
        result = 31 * result + (this.upperLimit != null ? this.upperLimit.hashCode() : 0);
        return result;
    }

    public boolean hasUpperLimit() {
        return this.upperLimit != null;
    }
}

