/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.deploy.impl.jcr;

import java.util.Collection;
import org.openl.rules.repository.ProductionRepositoryFactoryProxy;
import org.openl.rules.repository.REntity;
import org.openl.rules.repository.RFile;
import org.openl.rules.repository.RFolder;
import org.openl.rules.repository.RProductionDeployment;
import org.openl.rules.repository.RProductionRepository;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectFolder;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.rules.workspace.deploy.DeployID;
import org.openl.rules.workspace.deploy.DeploymentException;
import org.openl.rules.workspace.deploy.ProductionDeployer;
import org.openl.rules.workspace.repository.RulesRepositoryArtefact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrProductionDeployer
implements ProductionDeployer {
    private final WorkspaceUser user;

    public JcrProductionDeployer(WorkspaceUser user) {
        this.user = user;
    }

    private void copy(RFolder dest, ProjectFolder source) throws RRepositoryException, ProjectException {
        for (ProjectArtefact projectArtefact : source.getArtefacts()) {
            if (projectArtefact.isFolder()) {
                RFolder folder = dest.createFolder(projectArtefact.getName());
                this.copyProperties((REntity)folder, (RulesRepositoryArtefact)((Object)projectArtefact));
                this.copy(folder, (ProjectFolder)projectArtefact);
                continue;
            }
            this.copy(dest, (ProjectResource)projectArtefact);
        }
    }

    private void copy(RFolder folder, ProjectResource artefact) throws RRepositoryException, ProjectException {
        RFile rFile = folder.createFile(artefact.getName());
        rFile.setContent(artefact.getContent());
        this.copyProperties((REntity)rFile, (RulesRepositoryArtefact)((Object)artefact));
    }

    private void copyProperties(REntity rEntity, RulesRepositoryArtefact artefact) throws RRepositoryException {
        rEntity.setEffectiveDate(artefact.getEffectiveDate());
        rEntity.setExpirationDate(artefact.getExpirationDate());
        rEntity.setLineOfBusiness(artefact.getLineOfBusiness());
        rEntity.setProps(artefact.getProps());
    }

    @Override
    public DeployID deploy(Collection<? extends Project> projects) throws DeploymentException {
        String name = this.generatedDeployID(projects);
        return this.deploy(new DeployID(name), projects);
    }

    @Override
    public synchronized DeployID deploy(DeployID id, Collection<? extends Project> projects) throws DeploymentException {
        boolean alreadyDeployed = false;
        try {
            RProductionRepository rRepository = ProductionRepositoryFactoryProxy.getRepositoryInstance();
            if (rRepository.hasDeployment(id.getName())) {
                alreadyDeployed = true;
            } else {
                RProductionDeployment deployment = rRepository.createDeployment(id.getName());
                for (Project project : projects) {
                    this.deployProject(deployment, project);
                }
                deployment.save();
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to deploy: " + e.getMessage(), e);
        }
        if (alreadyDeployed) {
            throw new DeploymentException("Project is already deployed to production repository, id: " + id.getName(), null);
        }
        return id;
    }

    private void deployProject(RProductionDeployment deployment, Project project) throws RRepositoryException, ProjectException {
        RProject rProject = deployment.createProject(project.getName());
        this.copy(rProject.getRootFolder(), project);
    }

    private String generatedDeployID(Collection<? extends Project> projects) {
        StringBuilder name = new StringBuilder();
        for (Project project : projects) {
            name.append(project.getName());
            if (project.getVersion() != null) {
                name.append('-').append(project.getVersion().getVersionName());
            }
            name.append('_');
        }
        name.append(System.currentTimeMillis());
        return name.toString();
    }
}

