/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.dtr.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.NullRepository;
import org.openl.rules.repository.RDeploymentDescriptorProject;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.RRepository;
import org.openl.rules.repository.RulesRepositoryFactory;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.DeploymentDescriptorProject;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.impl.ArtefactPathImpl;
import org.openl.rules.workspace.dtr.DesignTimeRepository;
import org.openl.rules.workspace.dtr.RepositoryDDProject;
import org.openl.rules.workspace.dtr.RepositoryException;
import org.openl.rules.workspace.dtr.RepositoryProject;
import org.openl.rules.workspace.dtr.impl.RepositoryDeploymentDescriptorProjectImpl;
import org.openl.rules.workspace.dtr.impl.RepositoryProjectImpl;
import org.openl.util.MsgHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignTimeRepositoryImpl
implements DesignTimeRepository {
    private static final Log log = LogFactory.getLog(DesignTimeRepositoryImpl.class);
    private RRepository rulesRepository;
    private HashMap<String, RepositoryProjectImpl> projects;

    public DesignTimeRepositoryImpl() {
        try {
            this.rulesRepository = RulesRepositoryFactory.getRepositoryInstance();
        }
        catch (RRepositoryException e) {
            log.error((Object)("Cannot init DTR! " + e.getMessage()));
            this.rulesRepository = new NullRepository();
        }
        this.projects = new HashMap();
    }

    @Override
    public void copyDDProject(DeploymentDescriptorProject project, String name, WorkspaceUser user) throws ProjectException {
        this.createDDProject(name);
        RepositoryDDProject newProject = this.getDDProject(name);
        newProject.commit((Project)((Object)project), user);
    }

    @Override
    public void copyProject(Project project, String name, WorkspaceUser user) throws ProjectException {
        if (this.hasProject(name)) {
            throw new ProjectException("Project ''{0}'' is already exist in the repository!", null, name);
        }
        RRepository writeRep = null;
        try {
            log.debug((Object)"Opening temporary write session...");
            writeRep = RulesRepositoryFactory.getRepositoryInstance();
            log.debug((Object)"Wrapping temporary write project...");
            RepositoryProjectImpl newProject = this.wrapProject(writeRep.createProject(name), false);
            newProject.commit(project, user);
        }
        catch (RRepositoryException e) {
            throw new RepositoryException("Failed to create project ''{0}''!", (Throwable)e, name);
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to copy project ''{0}''!", (Throwable)e, name);
        }
        finally {
            if (writeRep != null) {
                log.debug((Object)"Releasing temporary write session...");
                writeRep.release();
            }
            this.projects.remove(name);
        }
    }

    @Override
    public void createDDProject(String name) throws RepositoryException {
        try {
            this.rulesRepository.createDDProject(name);
        }
        catch (RRepositoryException e) {
            throw new RepositoryException("Failed to create deployment project ''{0}''!", (Throwable)e, name);
        }
    }

    @Override
    public void createProject(String name) throws RepositoryException {
        try {
            this.rulesRepository.createProject(name);
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to create project ''{0}''!", (Throwable)e, name);
        }
    }

    @Override
    public ProjectArtefact getArtefactByPath(ArtefactPath artefactPath) throws ProjectException {
        String projectName = artefactPath.segment(0);
        RepositoryProject ralProject = this.getProject(projectName);
        ArtefactPath pathInProject = artefactPath.withoutFirstSegment();
        return ralProject.getArtefactByPath(pathInProject);
    }

    @Override
    public RepositoryDDProject getDDProject(String name) throws RepositoryException {
        try {
            return this.wrapDDProject(this.rulesRepository.getDDProject(name));
        }
        catch (RRepositoryException e) {
            throw new RepositoryException("Cannot find project ''{0}''!", (Throwable)e, name);
        }
    }

    @Override
    public RepositoryDDProject getDDProject(String name, CommonVersion version) throws RepositoryException {
        try {
            RDeploymentDescriptorProject ralDeploymentProject = this.rulesRepository.getDDProject(name);
            RDeploymentDescriptorProject oldProject = ralDeploymentProject.getProjectVersion(version);
            return this.wrapDDProject(oldProject);
        }
        catch (RRepositoryException e) {
            throw new RepositoryException("Cannot find project ''{0}'' or its version ''{1}''!", (Throwable)e, name, version.getVersionName());
        }
    }

    @Override
    public List<RepositoryDDProject> getDDProjects() throws RepositoryException {
        LinkedList<RepositoryDDProject> result = new LinkedList<RepositoryDDProject>();
        try {
            for (RDeploymentDescriptorProject ralDeploymentProject : this.rulesRepository.getDDProjects()) {
                RepositoryDDProject dtrDeploymentProject = this.wrapDDProject(ralDeploymentProject);
                result.add(dtrDeploymentProject);
            }
        }
        catch (RRepositoryException e) {
            log.error((Object)"Cannot list deployments projects!", (Throwable)e);
        }
        return result;
    }

    @Override
    public RepositoryProject getProject(String name) throws RepositoryException {
        if (!this.hasProject(name)) {
            throw new RepositoryException("Cannot find project ''{0}''!", null, name);
        }
        RepositoryProject cached = this.projects.get(name);
        if (cached != null) {
            return cached;
        }
        try {
            RProject ralProject = this.rulesRepository.getProject(name);
            return this.wrapProject(ralProject, true);
        }
        catch (RRepositoryException e) {
            throw new RepositoryException("Cannot find project ''{0}''!", (Throwable)e, name);
        }
    }

    @Override
    public RepositoryProject getProject(String name, CommonVersion version) throws RepositoryException {
        try {
            RProject ralProject = this.rulesRepository.getProject(name);
            RProject oldProject = ralProject.getProjectVersion(version);
            return this.wrapProject(oldProject, false);
        }
        catch (RRepositoryException e) {
            throw new RepositoryException("Cannot find project ''{0}'' or its version ''{1}''!", (Throwable)e, name, version.getVersionName());
        }
    }

    @Override
    public Collection<RepositoryProject> getProjects() {
        LinkedList<RepositoryProject> result = new LinkedList<RepositoryProject>();
        try {
            for (RProject ralProject : this.rulesRepository.getProjects()) {
                String name = ralProject.getName();
                RepositoryProject cached = this.projects.get(name);
                if (cached != null) {
                    result.add(cached);
                    continue;
                }
                RepositoryProjectImpl project = this.wrapProject(ralProject, true);
                result.add(project);
            }
        }
        catch (RRepositoryException e) {
            log.error((Object)"Cannot list projects!", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean hasDDProject(String name) {
        try {
            return this.rulesRepository.hasDDProject(name);
        }
        catch (RRepositoryException e) {
            String msg = MsgHelper.format((String)"Failed to check deployment project ''{0}'' in the repository!", (Object[])new Object[]{name});
            log.error((Object)msg, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean hasProject(String name) {
        RepositoryProject cached = this.projects.get(name);
        boolean inCache = cached != null;
        try {
            boolean inRAL = this.rulesRepository.hasProject(name);
            if (inRAL != inCache && !inRAL) {
                this.projects.remove(name);
            }
            return inRAL;
        }
        catch (RRepositoryException e) {
            String msg = MsgHelper.format((String)"Failed to check project ''{0}'' in the repository!", (Object[])new Object[]{name});
            log.error((Object)msg, (Throwable)e);
            return inCache;
        }
    }

    @Override
    public void updateProject(Project sourceProject, WorkspaceUser user, int major, int minor) throws RepositoryException {
        String name = sourceProject.getName();
        RepositoryProject dest = this.getProject(name);
        if (!dest.isLocked()) {
            throw new RepositoryException("Cannot update project ''{0}'' while it is not locked!", null, name);
        }
        WorkspaceUser lockedBy = dest.getlLockInfo().getLockedBy();
        if (!lockedBy.equals(user)) {
            throw new RepositoryException("Project ''{0}'' is locked by other user ({0})!", null, name, lockedBy.getUserName());
        }
        RRepository writeRep = null;
        try {
            log.debug((Object)"Opening temporary write session...");
            writeRep = RulesRepositoryFactory.getRepositoryInstance();
            log.debug((Object)"Wrapping temporary write project...");
            RepositoryProjectImpl project4Write = this.wrapProject(writeRep.getProject(name), false);
            if (major != 0 || minor != 0) {
                String msg = MsgHelper.format((String)"Raising project version (''{0}'' -> {1}.{2})...", (Object[])new Object[]{name, major, minor});
                log.debug((Object)msg);
                project4Write.riseVersion(major, minor);
            }
            project4Write.commit(sourceProject, user);
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to update project ''{0}''.", (Throwable)e, name);
        }
        finally {
            if (writeRep != null) {
                log.debug((Object)"Releasing temporary write session...");
                writeRep.release();
            }
            this.projects.remove(name);
        }
    }

    private RepositoryDDProject wrapDDProject(RDeploymentDescriptorProject ralDeploymentProject) {
        return new RepositoryDeploymentDescriptorProjectImpl(ralDeploymentProject);
    }

    private RepositoryProjectImpl wrapProject(RProject ralRulesProject, boolean cacheIt) {
        String name = ralRulesProject.getName();
        ArtefactPathImpl projectPath = new ArtefactPathImpl(new String[]{name});
        RepositoryProjectImpl dtrRulesProject = new RepositoryProjectImpl(ralRulesProject, (ArtefactPath)projectPath);
        if (cacheIt) {
            this.projects.put(name, dtrRulesProject);
        }
        return dtrRulesProject;
    }
}

