/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.dtr.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonUser;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.CommonVersionImpl;
import org.openl.rules.repository.RDeploymentDescriptorProject;
import org.openl.rules.repository.RProjectDescriptor;
import org.openl.rules.repository.RVersion;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.DeploymentDescriptorProject;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectDependency;
import org.openl.rules.workspace.abstracts.ProjectDescriptor;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.abstracts.impl.ArtefactPathImpl;
import org.openl.rules.workspace.dtr.LockInfo;
import org.openl.rules.workspace.dtr.RepositoryDDProject;
import org.openl.rules.workspace.dtr.RepositoryProjectArtefact;
import org.openl.rules.workspace.dtr.impl.LockInfoImpl;
import org.openl.rules.workspace.dtr.impl.RepositoryProjectDescriptorImpl;
import org.openl.rules.workspace.dtr.impl.RepositoryProjectVersionImpl;
import org.openl.rules.workspace.dtr.impl.RepositoryVersionInfoImpl;
import org.openl.rules.workspace.props.Property;
import org.openl.rules.workspace.props.PropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryDeploymentDescriptorProjectImpl
implements RepositoryDDProject {
    private static final Log log = LogFactory.getLog(RepositoryDeploymentDescriptorProjectImpl.class);
    private RDeploymentDescriptorProject rulesDescrProject;
    private String name;
    private ArtefactPath path;
    private HashMap<String, ProjectDescriptor> descriptors;

    public RepositoryDeploymentDescriptorProjectImpl(RDeploymentDescriptorProject rulesDescrProject) {
        this.rulesDescrProject = rulesDescrProject;
        this.name = rulesDescrProject.getName();
        this.path = new ArtefactPathImpl(new String[]{this.name});
        this.descriptors = new HashMap();
        for (RProjectDescriptor ralProjectDescriptor : rulesDescrProject.getProjectDescriptors()) {
            RepositoryProjectDescriptorImpl dtrProjectDescriptor = new RepositoryProjectDescriptorImpl(this, ralProjectDescriptor);
            this.descriptors.put(dtrProjectDescriptor.getProjectName(), dtrProjectDescriptor);
        }
    }

    @Override
    public ProjectDescriptor addProjectDescriptor(String projectName, CommonVersion version) throws ProjectException {
        if (this.descriptors.get(projectName) != null) {
            throw new ProjectException("Project Descriptor ''{0}'' already exists!", null, projectName);
        }
        RepositoryProjectDescriptorImpl dtrProjectDescriptor = new RepositoryProjectDescriptorImpl(this, projectName, version);
        this.descriptors.put(projectName, dtrProjectDescriptor);
        return dtrProjectDescriptor;
    }

    @Override
    public void addProperty(Property property) throws PropertyException {
        this.notSupportedProps();
    }

    @Override
    public void commit(Project source, CommonUser user) throws ProjectException {
        this.update(source);
        try {
            this.rulesDescrProject.commit(user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Failed to commit changes!", e);
        }
    }

    @Override
    public void delete() throws ProjectException {
        throw new ProjectException("Use delete(CommonUser) instead!");
    }

    @Override
    public void delete(CommonUser user) throws ProjectException {
        if (this.isMarkedForDeletion()) {
            throw new ProjectException("Deployment project ''{0}'' is already marked for deletion!", null, this.getName());
        }
        try {
            this.rulesDescrProject.delete(user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Cannot delete deployment project ''{0}''!", (Throwable)e, this.getName());
        }
    }

    protected void delete(String projectName) {
        this.descriptors.remove(projectName);
    }

    @Override
    public void erase(CommonUser user) throws ProjectException {
        try {
            this.rulesDescrProject.erase(user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Cannot erase deployment project ''{0}''!", (Throwable)e, this.getName());
        }
    }

    @Override
    public RepositoryProjectArtefact getArtefact(String name) throws ProjectException {
        this.notSupported();
        return null;
    }

    @Override
    public ProjectArtefact getArtefactByPath(ArtefactPath artefactPath) throws ProjectException {
        this.notSupported();
        return null;
    }

    @Override
    public ArtefactPath getArtefactPath() {
        return this.path;
    }

    @Override
    public Collection<RepositoryProjectArtefact> getArtefacts() {
        return null;
    }

    @Override
    public Collection<ProjectDependency> getDependencies() {
        return null;
    }

    @Override
    public Date getEffectiveDate() {
        return null;
    }

    @Override
    public Date getExpirationDate() {
        return null;
    }

    @Override
    public String getLineOfBusiness() {
        return null;
    }

    @Override
    public LockInfo getlLockInfo() {
        try {
            return new LockInfoImpl(this.rulesDescrProject.getLock());
        }
        catch (RRepositoryException e) {
            log.error((Object)"getLockInfo", (Throwable)e);
            return LockInfoImpl.NO_LOCK;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<ProjectDescriptor> getProjectDescriptors() {
        return this.descriptors.values();
    }

    @Override
    public Collection<Property> getProperties() {
        return null;
    }

    @Override
    public Property getProperty(String name) throws PropertyException {
        this.notSupportedProps();
        return null;
    }

    @Override
    public Map<String, Object> getProps() {
        return null;
    }

    @Override
    public ProjectVersion getVersion() {
        RVersion ralVersion = this.rulesDescrProject.getActiveVersion();
        RepositoryVersionInfoImpl info = new RepositoryVersionInfoImpl(ralVersion.getCreated(), ralVersion.getCreatedBy().getUserName());
        RepositoryProjectVersionImpl version = new RepositoryProjectVersionImpl((CommonVersion)ralVersion, info);
        return version;
    }

    @Override
    public Collection<ProjectVersion> getVersions() {
        LinkedList<ProjectVersion> vers = new LinkedList<ProjectVersion>();
        try {
            for (RVersion ralVersion : this.rulesDescrProject.getVersionHistory()) {
                RepositoryVersionInfoImpl dtrVersion = new RepositoryVersionInfoImpl(ralVersion.getCreated(), ralVersion.getCreatedBy().getUserName());
                vers.add(new RepositoryProjectVersionImpl((CommonVersion)ralVersion, dtrVersion));
            }
        }
        catch (RRepositoryException e) {
            log.error((Object)"Failed to get version history!", (Throwable)e);
        }
        return vers;
    }

    @Override
    public boolean hasArtefact(String name) {
        return false;
    }

    @Override
    public boolean hasProperty(String name) {
        return false;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isLocked() {
        try {
            return this.rulesDescrProject.isLocked();
        }
        catch (RRepositoryException e) {
            log.error((Object)"isLocked", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isMarkedForDeletion() {
        try {
            return this.rulesDescrProject.isMarked4Deletion();
        }
        catch (RRepositoryException e) {
            log.error((Object)"isMarkedForDeletion", (Throwable)e);
            return false;
        }
    }

    @Override
    public void lock(WorkspaceUser user) throws ProjectException {
        if (this.isLocked()) {
            throw new ProjectException("Deployment project ''{0}'' is already locked!", null, this.getName());
        }
        try {
            this.rulesDescrProject.lock((CommonUser)user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Cannot lock deployment project: " + e.getMessage(), e);
        }
    }

    protected void notSupported() throws ProjectException {
        throw new ProjectException("Not supported for deployment project!");
    }

    protected void notSupportedProps() throws PropertyException {
        throw new PropertyException("Not supported for deployment project!", null);
    }

    @Override
    public Property removeProperty(String name) throws PropertyException {
        this.notSupportedProps();
        return null;
    }

    @Override
    public void riseVersion(int major, int minor) throws ProjectException {
        try {
            this.rulesDescrProject.riseVersion(major, minor);
        }
        catch (RRepositoryException e) {
            throw new ProjectException(e.getMessage(), e);
        }
    }

    @Override
    public void setDependencies(Collection<ProjectDependency> dependencies) {
    }

    @Override
    public void setEffectiveDate(Date date) throws ProjectException {
        this.notSupported();
    }

    @Override
    public void setExpirationDate(Date date) throws ProjectException {
        this.notSupported();
    }

    @Override
    public void setLineOfBusiness(String lineOfBusiness) throws ProjectException {
        this.notSupported();
    }

    @Override
    public void setProjectDescriptors(Collection<ProjectDescriptor> projectDescriptors) throws ProjectException {
        HashMap<String, RepositoryProjectDescriptorImpl> newDescriptors = new HashMap<String, RepositoryProjectDescriptorImpl>();
        for (ProjectDescriptor projectDescriptor : projectDescriptors) {
            CommonVersion projectVersion = projectDescriptor.getProjectVersion();
            RepositoryProjectVersionImpl dtrProjectVersion = new RepositoryProjectVersionImpl(projectVersion, null);
            RepositoryProjectDescriptorImpl dtrProjectDescriptor = new RepositoryProjectDescriptorImpl(this, projectDescriptor.getProjectName(), dtrProjectVersion);
            newDescriptors.put(dtrProjectDescriptor.getProjectName(), dtrProjectDescriptor);
        }
        this.descriptors.clear();
        this.descriptors = newDescriptors;
    }

    @Override
    public void setProps(Map<String, Object> props) throws ProjectException {
        this.notSupported();
    }

    @Override
    public void undelete(CommonUser user) throws ProjectException {
        if (!this.isMarkedForDeletion()) {
            throw new ProjectException("Cannot undelete non-marked deployment project ''{0}''!", null, this.getName());
        }
        try {
            this.rulesDescrProject.undelete(user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Cannot undelete deployment project ''{0}''!", (Throwable)e, this.name);
        }
    }

    @Override
    public void unlock(WorkspaceUser user) throws ProjectException {
        if (!this.isLocked()) {
            throw new ProjectException("Cannot unlock non-locked deployment project ''{0}''!", null, this.getName());
        }
        try {
            this.rulesDescrProject.unlock((CommonUser)user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Cannot unlock pdeployment roject: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(DeploymentDescriptorProject deploymentProject) throws ProjectException {
        this.descriptors.clear();
        for (ProjectDescriptor projectDescriptor : deploymentProject.getProjectDescriptors()) {
            this.descriptors.put(projectDescriptor.getProjectName(), projectDescriptor);
        }
        LinkedList<RPD2> projectDescriptors = new LinkedList<RPD2>();
        for (ProjectDescriptor projectDescriptor : this.descriptors.values()) {
            RPD2 substituteProjectDescriptor = new RPD2(projectDescriptor);
            projectDescriptors.add(substituteProjectDescriptor);
        }
        try {
            this.rulesDescrProject.setProjectDescriptors(projectDescriptors);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Cannot update descriptors for ''{0}''!", (Throwable)e, this.getName());
        }
    }

    @Override
    public void update(ProjectArtefact srcArtefact) throws ProjectException {
        if (srcArtefact instanceof DeploymentDescriptorProject) {
            DeploymentDescriptorProject deploymentProject = (DeploymentDescriptorProject)((Object)srcArtefact);
            this.update(deploymentProject);
        }
    }

    private class RV2
    implements RVersion {
        private CommonVersion version;

        private RV2(CommonVersion version) {
            this.version = version;
        }

        public int compareTo(CommonVersion o) {
            return new CommonVersionImpl((CommonVersion)this).compareTo(o);
        }

        public Date getCreated() {
            return null;
        }

        public CommonUser getCreatedBy() {
            return null;
        }

        public int getMajor() {
            return this.version.getMajor();
        }

        public int getMinor() {
            return this.version.getMinor();
        }

        public int getRevision() {
            return this.version.getRevision();
        }

        public String getVersionName() {
            return this.version.getVersionName();
        }
    }

    private class RPD2
    implements RProjectDescriptor {
        private ProjectDescriptor pd;

        private RPD2(ProjectDescriptor pd) {
            this.pd = pd;
        }

        public String getProjectName() {
            return this.pd.getProjectName();
        }

        public RVersion getProjectVersion() {
            return new RV2(this.pd.getProjectVersion());
        }

        public void setProjectVersion(RVersion version) throws RRepositoryException {
        }
    }
}

