/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.dtr.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.REntity;
import org.openl.rules.repository.RProperty;
import org.openl.rules.repository.RPropertyType;
import org.openl.rules.repository.RVersion;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.dtr.RepositoryProjectArtefact;
import org.openl.rules.workspace.dtr.impl.RepositoryProjectVersionImpl;
import org.openl.rules.workspace.dtr.impl.RepositoryVersionInfoImpl;
import org.openl.rules.workspace.props.PropertiesContainer;
import org.openl.rules.workspace.props.Property;
import org.openl.rules.workspace.props.PropertyException;
import org.openl.rules.workspace.props.impl.PropertiesContainerImpl;
import org.openl.rules.workspace.repository.RulesRepositoryArtefact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryProjectArtefactImpl
implements RepositoryProjectArtefact {
    private static final Log log = LogFactory.getLog(RepositoryProjectArtefactImpl.class);
    private String name;
    private ArtefactPath path;
    private PropertiesContainer properties;
    private LinkedList<ProjectVersion> versions;
    private REntity rulesEntity;

    protected RepositoryProjectArtefactImpl(REntity rulesEntity, ArtefactPath path) {
        this.rulesEntity = rulesEntity;
        this.name = rulesEntity.getName();
        this.path = path;
        this.reLoadVersions();
        this.properties = new PropertiesContainerImpl();
    }

    @Override
    public void addProperty(Property property) throws PropertyException {
        throw new PropertyException("Not supported", null);
    }

    @Override
    public ArtefactPath getArtefactPath() {
        return this.path;
    }

    @Override
    public Date getEffectiveDate() {
        return this.rulesEntity.getEffectiveDate();
    }

    @Override
    public Date getExpirationDate() {
        return this.rulesEntity.getExpirationDate();
    }

    @Override
    public String getLineOfBusiness() {
        return this.rulesEntity.getLineOfBusiness();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Property> getProperties() {
        return this.properties.getProperties();
    }

    @Override
    public Property getProperty(String name) throws PropertyException {
        return this.properties.getProperty(name);
    }

    @Override
    public Map<String, Object> getProps() {
        return this.rulesEntity.getProps();
    }

    @Override
    public Collection<ProjectVersion> getVersions() {
        this.reLoadVersions();
        return this.versions;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.hasProperty(name);
    }

    protected void reLoadVersions() {
        LinkedList<RepositoryProjectVersionImpl> vers = new LinkedList<RepositoryProjectVersionImpl>();
        try {
            for (RVersion rv : this.rulesEntity.getVersionHistory()) {
                RepositoryVersionInfoImpl rvii = new RepositoryVersionInfoImpl(rv.getCreated(), rv.getCreatedBy().getUserName());
                vers.add(new RepositoryProjectVersionImpl((CommonVersion)rv, rvii));
            }
            this.versions = vers;
        }
        catch (RRepositoryException e) {
            log.error((Object)"Failed to get version history!", (Throwable)e);
        }
    }

    @Override
    public Property removeProperty(String name) throws PropertyException {
        throw new PropertyException("Not supported", null);
    }

    @Override
    public void setEffectiveDate(Date date) throws ProjectException {
        try {
            this.rulesEntity.setEffectiveDate(date);
        }
        catch (RRepositoryException e) {
            throw new ProjectException(null, e);
        }
    }

    @Override
    public void setExpirationDate(Date date) throws ProjectException {
        try {
            this.rulesEntity.setExpirationDate(date);
        }
        catch (RRepositoryException e) {
            throw new ProjectException(null, e);
        }
    }

    @Override
    public void setLineOfBusiness(String lineOfBusiness) throws ProjectException {
        try {
            this.rulesEntity.setLineOfBusiness(lineOfBusiness);
        }
        catch (RRepositoryException e) {
            throw new ProjectException(null, e);
        }
    }

    @Override
    public void setProps(Map<String, Object> props) throws ProjectException {
        try {
            this.rulesEntity.setProps(props);
        }
        catch (RRepositoryException e) {
            throw new ProjectException(null, e);
        }
    }

    @Override
    public void update(ProjectArtefact srcArtefact) throws ProjectException {
        String name;
        if (srcArtefact instanceof RulesRepositoryArtefact) {
            RulesRepositoryArtefact rra = (RulesRepositoryArtefact)((Object)srcArtefact);
            try {
                this.rulesEntity.setEffectiveDate(rra.getEffectiveDate());
                this.rulesEntity.setExpirationDate(rra.getExpirationDate());
                this.rulesEntity.setLineOfBusiness(rra.getLineOfBusiness());
                this.rulesEntity.setProps(rra.getProps());
            }
            catch (RRepositoryException e) {
                throw new ProjectException("Failed to update rules properties", e);
            }
        }
        HashMap<String, Property> srcProps = new HashMap<String, Property>();
        for (Property p : srcArtefact.getProperties()) {
            srcProps.put(p.getName(), p);
        }
        HashMap<String, RProperty> rulesProps = new HashMap<String, RProperty>();
        for (RProperty rp : this.rulesEntity.getProperties()) {
            rulesProps.put(rp.getName(), rp);
        }
        for (RProperty rp : rulesProps.values()) {
            name = rp.getName();
            Property srcProp = (Property)srcProps.get(name);
            if (srcProp == null) {
                try {
                    this.rulesEntity.removeProperty(name);
                    rulesProps.remove(name);
                    continue;
                }
                catch (RRepositoryException e) {
                    throw new ProjectException("Cannot remove property {0}", (Throwable)e, name);
                }
            }
            Object rulesValue = rp.getValue();
            Object srcValue = srcProp.getValue();
            if (srcValue.equals(rulesValue)) continue;
            try {
                rp.setValue(srcValue);
            }
            catch (RRepositoryException e) {
                throw new ProjectException("Cannot update property {0}", (Throwable)e, name);
            }
        }
        for (Property p : srcProps.values()) {
            RPropertyType type;
            name = p.getName();
            RProperty rp = (RProperty)rulesProps.get(name);
            if (rp != null) continue;
            switch (p.getType()) {
                case DATE: {
                    type = RPropertyType.DATE;
                    break;
                }
                default: {
                    type = RPropertyType.STRING;
                }
            }
            try {
                this.rulesEntity.addProperty(name, type, p.getValue());
            }
            catch (RRepositoryException e) {
                throw new ProjectException("Cannot add property {0}", (Throwable)e, name);
            }
        }
    }
}

