/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.dtr.impl;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.REntity;
import org.openl.rules.repository.RFile;
import org.openl.rules.repository.RFolder;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectFolder;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.rules.workspace.dtr.RepositoryProjectArtefact;
import org.openl.rules.workspace.dtr.RepositoryProjectFolder;
import org.openl.rules.workspace.dtr.RepositoryProjectResource;
import org.openl.rules.workspace.dtr.impl.RepositoryProjectArtefactImpl;
import org.openl.rules.workspace.dtr.impl.RepositoryProjectResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryProjectFolderImpl
extends RepositoryProjectArtefactImpl
implements RepositoryProjectFolder {
    private static final Log log = LogFactory.getLog(RepositoryProjectFolderImpl.class);
    private RFolder rulesFolder;

    protected RepositoryProjectFolderImpl(RFolder rulesFolder, ArtefactPath path) {
        super((REntity)rulesFolder, path);
        this.rulesFolder = rulesFolder;
    }

    RepositoryProjectFolderImpl(RProject rulesProject, RFolder rulesFolder, ArtefactPath path) {
        super((REntity)rulesProject, path);
        this.rulesFolder = rulesFolder;
    }

    private void addArtefact(ProjectArtefact artefact) throws ProjectException {
        try {
            if (artefact.isFolder()) {
                ProjectFolder folder = (ProjectFolder)artefact;
                RFolder rf = this.rulesFolder.createFolder(folder.getName());
                this.wrapFolder(rf).update(folder);
            } else {
                ProjectResource res = (ProjectResource)artefact;
                RFile rf = this.rulesFolder.createFile(res.getName());
                this.wrapFile(rf).update(res);
            }
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Failed to update artefact ''{0}''", (Throwable)e, this.getArtefactPath().getStringValue());
        }
    }

    @Override
    public void delete() throws ProjectException {
        try {
            this.rulesFolder.delete();
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Failed to delete project folder ''{0}''", (Throwable)e, this.getArtefactPath().getStringValue());
        }
    }

    @Override
    public RepositoryProjectArtefact getArtefact(String name) throws ProjectException {
        RRepositoryException rre = null;
        try {
            for (RFolder f : this.rulesFolder.getFolders()) {
                if (!name.equals(f.getName())) continue;
                return this.wrapFolder(f);
            }
            for (RFolder f : this.rulesFolder.getFiles()) {
                if (!name.equals(f.getName())) continue;
                return this.wrapFile((RFile)f);
            }
        }
        catch (RRepositoryException e) {
            rre = e;
        }
        throw new ProjectException("Cannot find project artefact ''{0}''!", (Throwable)rre, name);
    }

    @Override
    public Collection<RepositoryProjectArtefact> getArtefacts() {
        LinkedList<RepositoryProjectArtefact> result = new LinkedList<RepositoryProjectArtefact>();
        try {
            for (RFolder rf : this.rulesFolder.getFolders()) {
                RepositoryProjectFolder folder = this.wrapFolder(rf);
                result.add(folder);
            }
            for (RFolder rf : this.rulesFolder.getFiles()) {
                RepositoryProjectResource resource = this.wrapFile((RFile)rf);
                result.add(resource);
            }
        }
        catch (RRepositoryException e) {
            log.error((Object)"Cannot get artefacts!", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean hasArtefact(String name) {
        try {
            this.getArtefact(name);
            return true;
        }
        catch (ProjectException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"hasArtefact", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void update(ProjectArtefact srcArtefact) throws ProjectException {
        String name;
        ProjectFolder srcFolder = (ProjectFolder)srcArtefact;
        super.update(srcArtefact);
        for (RepositoryProjectArtefact repositoryProjectArtefact : this.getArtefacts()) {
            name = repositoryProjectArtefact.getName();
            if (!srcFolder.hasArtefact(name)) {
                repositoryProjectArtefact.delete();
                continue;
            }
            ProjectArtefact artefact = srcFolder.getArtefact(name);
            if (repositoryProjectArtefact.isFolder() == artefact.isFolder()) {
                repositoryProjectArtefact.update(artefact);
                continue;
            }
            repositoryProjectArtefact.delete();
        }
        for (ProjectArtefact projectArtefact : srcFolder.getArtefacts()) {
            name = projectArtefact.getName();
            if (this.hasArtefact(name)) continue;
            this.addArtefact(projectArtefact);
        }
    }

    private RepositoryProjectResource wrapFile(RFile file) {
        ArtefactPath ap = this.getArtefactPath().withSegment(file.getName());
        return new RepositoryProjectResourceImpl(file, ap);
    }

    private RepositoryProjectFolder wrapFolder(RFolder folder) {
        ArtefactPath ap = this.getArtefactPath().withSegment(folder.getName());
        return new RepositoryProjectFolderImpl(folder, ap);
    }
}

