/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.dtr.impl;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonUser;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.RDependency;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.RVersion;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectDependency;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.abstracts.impl.ProjectDependencyImpl;
import org.openl.rules.workspace.dtr.LockInfo;
import org.openl.rules.workspace.dtr.RepositoryProject;
import org.openl.rules.workspace.dtr.RepositoryProjectArtefact;
import org.openl.rules.workspace.dtr.impl.LockInfoImpl;
import org.openl.rules.workspace.dtr.impl.RepositoryProjectFolderImpl;
import org.openl.rules.workspace.dtr.impl.RepositoryProjectVersionImpl;
import org.openl.rules.workspace.dtr.impl.RepositoryVersionInfoImpl;
import org.openl.util.MsgHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryProjectImpl
extends RepositoryProjectFolderImpl
implements RepositoryProject {
    private static final Log log = LogFactory.getLog(RepositoryProjectImpl.class);
    private RProject rulesProject;

    protected RepositoryProjectImpl(RProject rulesProject, ArtefactPath path) {
        super(rulesProject, rulesProject.getRootFolder(), path);
        this.rulesProject = rulesProject;
    }

    @Override
    public void commit(Project source, CommonUser user) throws ProjectException {
        String msg;
        if (log.isDebugEnabled()) {
            msg = MsgHelper.format((String)"Updating project ''{0}''...", (Object[])new Object[]{this.getName()});
            log.debug((Object)msg);
        }
        this.update(source);
        try {
            msg = MsgHelper.format((String)"Committing project ''{0}'' by user ''{1}''...", (Object[])new Object[]{this.getName(), user.getUserName()});
            log.debug((Object)msg);
            this.rulesProject.commit(user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Failed to commit changes!", e);
        }
    }

    @Override
    public void delete() throws ProjectException {
        throw new ProjectException("Use delete(CommonUser) instead!");
    }

    @Override
    public void delete(CommonUser user) throws ProjectException {
        if (this.isMarkedForDeletion()) {
            throw new ProjectException("Project ''{0}'' is already marked for deletion!", null, this.getName());
        }
        try {
            this.rulesProject.delete(user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Failed to delete project ''{0}''!", (Throwable)e, this.getName());
        }
    }

    @Override
    public void erase(CommonUser user) throws ProjectException {
        try {
            this.rulesProject.erase(user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Failed to erase project ''{0}''!", (Throwable)e, this.getName());
        }
    }

    @Override
    public RepositoryProjectArtefact getArtefactByPath(ArtefactPath artefactPath) throws ProjectException {
        RepositoryProjectArtefact a = this;
        for (String s : artefactPath.getSegments()) {
            a = a.getArtefact(s);
        }
        return a;
    }

    @Override
    public Collection<ProjectDependency> getDependencies() {
        LinkedList<ProjectDependency> result = new LinkedList<ProjectDependency>();
        try {
            for (RDependency rDep : this.rulesProject.getDependencies()) {
                String projectName = rDep.getProjectName();
                RepositoryProjectVersionImpl lowVer = new RepositoryProjectVersionImpl(rDep.getLowerLimit(), null);
                RepositoryProjectVersionImpl upVer = null;
                CommonVersion dependencyUpperLimit = rDep.getUpperLimit();
                if (dependencyUpperLimit != null) {
                    upVer = new RepositoryProjectVersionImpl(dependencyUpperLimit, null);
                }
                ProjectDependencyImpl pd = new ProjectDependencyImpl(projectName, lowVer, upVer);
                result.add(pd);
            }
        }
        catch (RRepositoryException e) {
            log.error((Object)"Cannot get dependencies!", (Throwable)e);
        }
        return result;
    }

    @Override
    public LockInfo getlLockInfo() {
        try {
            return new LockInfoImpl(this.rulesProject.getLock());
        }
        catch (RRepositoryException e) {
            log.error((Object)"getLockInfo", (Throwable)e);
            return LockInfoImpl.NO_LOCK;
        }
    }

    @Override
    public ProjectVersion getVersion() {
        RVersion rv = this.rulesProject.getActiveVersion();
        if (rv == null) {
            return null;
        }
        RepositoryVersionInfoImpl info = new RepositoryVersionInfoImpl(rv.getCreated(), rv.getCreatedBy().getUserName());
        RepositoryProjectVersionImpl version = new RepositoryProjectVersionImpl((CommonVersion)rv, info);
        return version;
    }

    @Override
    public boolean isLocked() {
        try {
            return this.rulesProject.isLocked();
        }
        catch (RRepositoryException e) {
            log.error((Object)"isLocked", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isMarkedForDeletion() {
        try {
            return this.rulesProject.isMarked4Deletion();
        }
        catch (RRepositoryException e) {
            log.debug((Object)"isMarkedForDeletion", (Throwable)e);
            return true;
        }
    }

    @Override
    public void lock(WorkspaceUser user) throws ProjectException {
        if (this.isLocked()) {
            throw new ProjectException("Project ''{0}'' is already locked!", null, this.getName());
        }
        try {
            this.rulesProject.lock((CommonUser)user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Cannot lock project ''{0}'': " + e.getMessage(), (Throwable)e, this.getName());
        }
    }

    @Override
    public void riseVersion(int major, int minor) throws ProjectException {
        try {
            this.rulesProject.riseVersion(major, minor);
        }
        catch (RRepositoryException e) {
            throw new ProjectException(e.getMessage(), e);
        }
    }

    @Override
    public void setDependencies(Collection<ProjectDependency> dependencies) throws ProjectException {
        try {
            LinkedList<ProjectDependency> newDeps = new LinkedList<ProjectDependency>();
            for (ProjectDependency pd : dependencies) {
                newDeps.add(pd);
            }
            this.rulesProject.setDependencies(newDeps);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Cannot update dependencies!", e);
        }
    }

    @Override
    public void undelete(CommonUser user) throws ProjectException {
        if (!this.isMarkedForDeletion()) {
            throw new ProjectException("Cannot undelete non-marked project ''{0}''!", null, this.getName());
        }
        try {
            this.rulesProject.undelete(user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Failed to undelete project ''{0}''!", (Throwable)e, this.getName());
        }
    }

    @Override
    public void unlock(WorkspaceUser user) throws ProjectException {
        if (!this.isLocked()) {
            throw new ProjectException("Cannot unlock non-locked project ''{0}''!", null, this.getName());
        }
        try {
            this.rulesProject.unlock((CommonUser)user);
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Cannot unlock project ''{0}'': " + e.getMessage(), (Throwable)e, this.getName());
        }
    }

    @Override
    public void update(ProjectArtefact srcArtefact) throws ProjectException {
        Project srcProject = (Project)srcArtefact;
        super.update(srcArtefact);
        try {
            this.rulesProject.setDependencies(srcProject.getDependencies());
        }
        catch (RRepositoryException e) {
            throw new ProjectException("Cannot update dependencies!", e);
        }
    }
}

