/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.dtr.impl;

import org.openl.rules.repository.CommonVersion;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.abstracts.VersionInfo;

public class RepositoryProjectVersionImpl
implements ProjectVersion {
    private static final long serialVersionUID = -5156747482692477220L;
    private int major;
    private int minor;
    private int revision;
    private transient String versionName;
    private VersionInfo versionInfo;

    public RepositoryProjectVersionImpl(CommonVersion version, VersionInfo versionInfo) {
        this.major = version.getMajor();
        this.minor = version.getMinor();
        this.revision = version.getRevision();
        this.versionInfo = versionInfo;
    }

    public RepositoryProjectVersionImpl(int major, int minor, int revision, VersionInfo versionInfo) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.versionInfo = versionInfo;
    }

    public int compareTo(CommonVersion o) {
        if (this.major != o.getMajor()) {
            return this.major < o.getMajor() ? -1 : 1;
        }
        if (this.minor != o.getMinor()) {
            return this.minor < o.getMinor() ? -1 : 1;
        }
        if (this.revision != o.getRevision()) {
            return this.revision < o.getRevision() ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ProjectVersion && this.compareTo((ProjectVersion)o) == 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public String getVersionName() {
        if (this.versionName == null) {
            this.versionName = this.major + "." + this.minor + "." + this.revision;
        }
        return this.versionName;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.revision;
        return result;
    }
}

