/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.lw.impl;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.util.MsgHelper;

public class FolderHelper {
    private static final Log log = LogFactory.getLog(FolderHelper.class);
    public static final String PROPERTIES_FOLDER = ".studioProps";
    public static final String FOLDER_PROPERTIES_FOLDER = "folder-props";
    public static final String FOLDER_PROPERTIES_FILE = "..studioProps.folder";
    public static final String RESOURCE_PROPERTIES_EXT = ".props";

    public static boolean checkOrCreateFolder(File location) {
        if (location.exists()) {
            return true;
        }
        return location.mkdirs();
    }

    public static boolean clearFolder(File folder) {
        File[] files;
        if (log.isDebugEnabled()) {
            log.debug((Object)MsgHelper.format((String)"Clearing folder ''{0}''", (Object[])new Object[]{folder}));
        }
        if ((files = folder.listFiles()) == null) {
            return true;
        }
        boolean failures = false;
        for (File file : files) {
            if (file.isFile()) {
                if (file.delete()) continue;
                failures = true;
                log.debug((Object)MsgHelper.format((String)"Failed to delete file ''{0}''!", (Object[])new Object[]{file.getAbsolutePath()}));
                continue;
            }
            if (FolderHelper.deleteFolder(file)) continue;
            failures = true;
        }
        return !failures;
    }

    public static boolean deleteFolder(File folder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)MsgHelper.format((String)"Deleting folder ''{0}''", (Object[])new Object[]{folder}));
        }
        boolean failures = false;
        if (folder.isDirectory()) {
            File[] files;
            for (File f : files = folder.listFiles()) {
                if (f.isDirectory()) {
                    if (FolderHelper.deleteFolder(f)) continue;
                    failures = true;
                    continue;
                }
                if (f.delete()) continue;
                failures = true;
                log.debug((Object)MsgHelper.format((String)"Failed to delete file ''{0}''!", (Object[])new Object[]{f.getAbsolutePath()}));
            }
            if (!folder.delete()) {
                log.debug((Object)MsgHelper.format((String)"Failed to delete folder ''{0}''!", (Object[])new Object[]{folder.getAbsolutePath()}));
            }
        }
        return !failures;
    }

    public static File generateSubLocation(File location, String name) {
        return new File(location, name);
    }

    public static boolean isParent(File parent, File child) {
        return child != null && (child.equals(parent) || FolderHelper.isParent(parent, child.getParentFile()));
    }
}

