/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.lw.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.lw.LocalProjectArtefact;
import org.openl.rules.workspace.lw.impl.StateHolder;
import org.openl.rules.workspace.props.Property;
import org.openl.rules.workspace.props.PropertyException;
import org.openl.rules.workspace.props.impl.PropertiesContainerImpl;
import org.openl.rules.workspace.repository.RulesRepositoryArtefact;
import org.openl.util.MsgHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalProjectArtefactImpl
implements LocalProjectArtefact {
    private static final Log log = LogFactory.getLog(LocalProjectArtefactImpl.class);
    private String name;
    private ArtefactPath path;
    private File location;
    private Date effectiveDate;
    private Date expirationDate;
    private String lineOfBusiness;
    private Map<String, Object> props;
    private PropertiesContainerImpl properties;
    private boolean isNew;
    private boolean isChanged;

    public LocalProjectArtefactImpl(String name, ArtefactPath path, File location) {
        this.name = name;
        this.path = path;
        this.location = location;
        this.properties = new PropertiesContainerImpl();
    }

    @Override
    public void addProperty(Property property) throws PropertyException {
        this.properties.addProperty(property);
    }

    protected void downloadArtefact(ProjectArtefact artefact) throws ProjectException {
        if (artefact instanceof RulesRepositoryArtefact) {
            RulesRepositoryArtefact rulesArtefact = (RulesRepositoryArtefact)((Object)artefact);
            this.effectiveDate = rulesArtefact.getEffectiveDate();
            this.expirationDate = rulesArtefact.getExpirationDate();
            this.lineOfBusiness = rulesArtefact.getLineOfBusiness();
            this.props = rulesArtefact.getProps();
        }
    }

    @Override
    public ArtefactPath getArtefactPath() {
        return this.path;
    }

    @Override
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    @Override
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public String getLineOfBusiness() {
        return this.lineOfBusiness;
    }

    protected File getLocation() {
        return this.location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Property> getProperties() {
        return this.properties.getProperties();
    }

    @Override
    public Property getProperty(String name) throws PropertyException {
        return this.properties.getProperty(name);
    }

    @Override
    public Map<String, Object> getProps() {
        return this.props;
    }

    public StateHolder getState() {
        ArtefactStateHolder state = new ArtefactStateHolder();
        state.isNew = this.isNew;
        state.isChanged = this.isChanged;
        state.effectiveDate = this.effectiveDate;
        state.expirationDate = this.expirationDate;
        state.LOB = this.lineOfBusiness;
        state.props = this.props;
        state.properties = new ArrayList<Property>(this.properties.getProperties());
        return state;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.hasProperty(name);
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void remove() {
        File f = this.getLocation();
        if (!f.exists()) {
            String msg = MsgHelper.format((String)"No file ''{0}'', nothing to remove.", (Object[])new Object[]{f.getAbsolutePath()});
            log.debug((Object)msg);
        } else if (!f.delete()) {
            String msg = MsgHelper.format((String)"Failed to remove file ''{0}''!", (Object[])new Object[]{f.getAbsolutePath()});
            log.warn((Object)msg);
        }
    }

    @Override
    public Property removeProperty(String name) throws PropertyException {
        return this.properties.removeProperty(name);
    }

    protected void resetNewAndChanged() {
        this.setNew(false);
        this.setChanged(false);
    }

    protected void setChanged(boolean changed) {
        this.isChanged = changed;
    }

    @Override
    public void setEffectiveDate(Date date) throws ProjectException {
        this.effectiveDate = date;
    }

    @Override
    public void setExpirationDate(Date date) throws ProjectException {
        this.expirationDate = date;
    }

    @Override
    public void setLineOfBusiness(String lineOfBusiness) throws ProjectException {
        this.lineOfBusiness = lineOfBusiness;
    }

    protected void setNew(boolean aNew) {
        this.isNew = aNew;
    }

    @Override
    public void setProps(Map<String, Object> props) throws ProjectException {
        this.props = props;
    }

    public void setState(StateHolder aState) throws PropertyException {
        ArtefactStateHolder state = (ArtefactStateHolder)aState;
        this.effectiveDate = state.effectiveDate;
        this.expirationDate = state.expirationDate;
        this.lineOfBusiness = state.LOB;
        this.props = state.props;
        this.properties.removeAll();
        for (Property prop : state.properties) {
            this.properties.addProperty(prop);
        }
        this.isNew = state.isNew;
        this.isChanged = state.isChanged;
    }

    private static class ArtefactStateHolder
    implements StateHolder {
        private static final long serialVersionUID = 1049629652852513808L;
        boolean isNew;
        boolean isChanged;
        Date effectiveDate;
        Date expirationDate;
        String LOB;
        Map<String, Object> props;
        Collection<Property> properties;

        private ArtefactStateHolder() {
        }
    }
}

