/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.lw.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectFolder;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.rules.workspace.lw.LocalProjectArtefact;
import org.openl.rules.workspace.lw.LocalProjectFolder;
import org.openl.rules.workspace.lw.LocalProjectResource;
import org.openl.rules.workspace.lw.impl.FolderHelper;
import org.openl.rules.workspace.lw.impl.LocalProjectArtefactImpl;
import org.openl.rules.workspace.lw.impl.LocalProjectResourceImpl;
import org.openl.rules.workspace.lw.impl.StateHolder;
import org.openl.rules.workspace.props.PropertyException;
import org.openl.util.MsgHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalProjectFolderImpl
extends LocalProjectArtefactImpl
implements LocalProjectFolder {
    private static final Log log = LogFactory.getLog(LocalProjectFolderImpl.class);
    private Map<String, LocalProjectArtefact> artefacts;
    private boolean isPendingRefresh;
    private FileFilter localWorkSpaceFileFilter;

    public LocalProjectFolderImpl(String name, ArtefactPath path, File location, FileFilter localWorkspaceFileFilter) {
        super(name, path, location);
        this.localWorkSpaceFileFilter = localWorkspaceFileFilter;
        this.artefacts = new HashMap<String, LocalProjectArtefact>();
        this.isPendingRefresh = true;
    }

    private void addArtefact(LocalProjectArtefactImpl newArtefact) {
        newArtefact.setChanged(false);
        newArtefact.setNew(true);
        this.artefacts.put(newArtefact.getName(), newArtefact);
        this.setChanged(true);
    }

    protected void addAsNew(File f) {
        String name = f.getName();
        ArtefactPath ap = this.getArtefactPath().withSegment(name);
        LocalProjectArtefactImpl newArtefact = f.isDirectory() ? new LocalProjectFolderImpl(name, ap, f, this.localWorkSpaceFileFilter) : new LocalProjectResourceImpl(name, ap, f);
        newArtefact.refresh();
        this.addArtefact(newArtefact);
    }

    @Override
    public LocalProjectFolder addFolder(String name) throws ProjectException {
        this.checkPendingRefresh();
        if (this.artefacts.get(name) != null) {
            throw new ProjectException("Artefact with name ''{0}'' already exists!", null, name);
        }
        File f = FolderHelper.generateSubLocation(this.getLocation(), name);
        if (!FolderHelper.checkOrCreateFolder(f)) {
            throw new ProjectException("Failed to create folder ''{0}''!", null, f.getAbsolutePath());
        }
        ArtefactPath ap = this.getArtefactPath().withSegment(name);
        LocalProjectFolderImpl newFolder = new LocalProjectFolderImpl(name, ap, f, this.localWorkSpaceFileFilter);
        this.addArtefact(newFolder);
        return newFolder;
    }

    @Override
    public LocalProjectResource addResource(String name, ProjectResource resource) throws ProjectException {
        this.checkPendingRefresh();
        if (this.artefacts.get(name) != null) {
            throw new ProjectException("Artefact with name ''{0}'' already exists!", null, name);
        }
        File f = FolderHelper.generateSubLocation(this.getLocation(), name);
        ArtefactPath ap = this.getArtefactPath().withSegment(name);
        LocalProjectResourceImpl newResource = new LocalProjectResourceImpl(name, ap, f);
        newResource.downloadArtefact(resource);
        this.addArtefact(newResource);
        return newResource;
    }

    private void checkPendingRefresh() {
        if (!this.isPendingRefresh) {
            return;
        }
        this.realRefresh();
    }

    protected void downloadArtefact(ProjectFolder folder) throws ProjectException {
        super.downloadArtefact(folder);
        File location = this.getLocation();
        if (!location.exists() && !location.mkdirs()) {
            String msg = MsgHelper.format((String)"Cannot create folder ''{0}''!", (Object[])new Object[]{location.getAbsolutePath()});
            log.error((Object)msg);
        }
        for (ProjectArtefact projectArtefact : folder.getArtefacts()) {
            String name = projectArtefact.getName();
            ArtefactPath ap = this.getArtefactPath().withSegment(name);
            File f = new File(location, name);
            if (projectArtefact.isFolder()) {
                ProjectFolder pf = (ProjectFolder)projectArtefact;
                LocalProjectFolderImpl lpfi = new LocalProjectFolderImpl(name, ap, f, this.localWorkSpaceFileFilter);
                lpfi.downloadArtefact(pf);
                this.artefacts.put(name, lpfi);
                continue;
            }
            ProjectResource pr = (ProjectResource)projectArtefact;
            LocalProjectResourceImpl lpri = new LocalProjectResourceImpl(name, ap, f);
            lpri.downloadArtefact(pr);
            this.artefacts.put(name, lpri);
        }
    }

    @Override
    public LocalProjectArtefact getArtefact(String name) throws ProjectException {
        this.checkPendingRefresh();
        LocalProjectArtefact lpa = this.artefacts.get(name);
        if (lpa == null) {
            throw new ProjectException("Cannot find project artefact ''{0}''", null, name);
        }
        return lpa;
    }

    @Override
    public Collection<LocalProjectArtefact> getArtefacts() {
        this.checkPendingRefresh();
        return this.artefacts.values();
    }

    @Override
    public StateHolder getState() {
        return super.getState();
    }

    @Override
    public boolean hasArtefact(String name) {
        this.checkPendingRefresh();
        return this.artefacts.get(name) != null;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    private void realRefresh() {
        this.isPendingRefresh = false;
        File[] files = this.getLocation().listFiles(this.localWorkSpaceFileFilter);
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (File f : files) {
            fileMap.put(f.getName(), f);
        }
        Iterator<Map.Entry<String, LocalProjectArtefact>> it = this.artefacts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, LocalProjectArtefact> entry = it.next();
            LocalProjectArtefact lpa = entry.getValue();
            String name = lpa.getName();
            if (fileMap.containsKey(name)) continue;
            lpa.remove();
            it.remove();
            this.setChanged(true);
        }
        for (File f : files) {
            String name = f.getName();
            LocalProjectArtefact lpa = this.artefacts.get(name);
            if (lpa == null) {
                this.addAsNew(f);
                continue;
            }
            if (f.isDirectory() != lpa.isFolder()) {
                lpa.remove();
                this.addAsNew(f);
                continue;
            }
            lpa.refresh();
        }
    }

    @Override
    public void refresh() {
        this.isPendingRefresh = true;
    }

    @Override
    public void remove() {
        for (LocalProjectArtefact lpa : this.artefacts.values()) {
            lpa.remove();
        }
        this.artefacts.clear();
        FolderHelper.clearFolder(this.getLocation());
        super.remove();
    }

    @Override
    protected void resetNewAndChanged() {
        for (LocalProjectArtefact artefact : this.artefacts.values()) {
            ((LocalProjectArtefactImpl)artefact).resetNewAndChanged();
        }
        super.resetNewAndChanged();
    }

    @Override
    public void setState(StateHolder aState) throws PropertyException {
        super.setState(aState);
    }
}

