/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.lw.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectDependency;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.dtr.impl.RepositoryProjectVersionImpl;
import org.openl.rules.workspace.lw.LocalProject;
import org.openl.rules.workspace.lw.LocalProjectArtefact;
import org.openl.rules.workspace.lw.impl.LocalProjectFolderImpl;
import org.openl.rules.workspace.lw.impl.LocalWorkspaceImpl;
import org.openl.rules.workspace.lw.impl.StateHolder;
import org.openl.rules.workspace.lw.impl.StatePersistance;
import org.openl.rules.workspace.props.PropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalProjectImpl
extends LocalProjectFolderImpl
implements LocalProject {
    private static final Log log = LogFactory.getLog(LocalProjectImpl.class);
    private static final LinkedList<ProjectDependency> EMPTY_LIST = new LinkedList();
    private ProjectVersion version = new RepositoryProjectVersionImpl(0, 0, 0, null);
    private Collection<ProjectDependency> dependencies;
    private LocalWorkspaceImpl localWorkspace;

    public LocalProjectImpl(String name, ArtefactPath path, File location, LocalWorkspaceImpl localWorkspace, FileFilter localWorkspaceFileFilter) {
        super(name, path, location, localWorkspaceFileFilter);
        this.localWorkspace = localWorkspace;
    }

    @Override
    public void checkedIn(ProjectVersion newVersion) {
        this.version = newVersion;
        this.resetNewAndChanged();
        try {
            this.save();
        }
        catch (ProjectException e) {
            log.error((Object)"Failed to save local project state!", (Throwable)e);
        }
    }

    protected void downloadArtefact(Project project) throws ProjectException {
        super.downloadArtefact(project);
        this.version = project.getVersion();
        this.dependencies = project.getDependencies();
        this.resetNewAndChanged();
    }

    @Override
    public LocalProjectArtefact getArtefactByPath(ArtefactPath artefactPath) throws ProjectException {
        LocalProjectArtefact lpa = this;
        for (String s : artefactPath.getSegments()) {
            lpa = lpa.getArtefact(s);
        }
        return lpa;
    }

    @Override
    public Collection<ProjectDependency> getDependencies() {
        return this.dependencies == null ? EMPTY_LIST : Collections.unmodifiableCollection(this.dependencies);
    }

    @Override
    public StateHolder getState() {
        ProjectStateHolder state = new ProjectStateHolder();
        state.parent = super.getState();
        state.version = this.version;
        state.dependencies = new ArrayList<ProjectDependency>(this.getDependencies());
        return state;
    }

    @Override
    public ProjectVersion getVersion() {
        return this.version;
    }

    @Override
    public synchronized void load() throws ProjectException {
        this.refresh();
        new StatePersistance(this).load();
    }

    @Override
    public void remove() {
        super.remove();
        this.localWorkspace.notifyRemoved(this);
    }

    @Override
    public synchronized void save() throws ProjectException {
        this.saveProjectState();
    }

    private void saveProjectState() throws ProjectException {
        new StatePersistance(this).save();
    }

    @Override
    public void setDependencies(Collection<ProjectDependency> dependencies) {
        this.dependencies = new ArrayList<ProjectDependency>(dependencies);
    }

    @Override
    public void setState(StateHolder aState) throws PropertyException {
        ProjectStateHolder state = (ProjectStateHolder)aState;
        super.setState(state.parent);
        this.version = state.version;
        this.dependencies = new ArrayList<ProjectDependency>(state.dependencies);
    }

    private static class ProjectStateHolder
    implements StateHolder {
        private static final long serialVersionUID = 1659670527173898554L;
        StateHolder parent;
        ProjectVersion version;
        Collection<ProjectDependency> dependencies;

        private ProjectStateHolder() {
        }
    }
}

