/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.lw.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.rules.workspace.lw.LocalProjectArtefact;
import org.openl.rules.workspace.lw.LocalProjectResource;
import org.openl.rules.workspace.lw.impl.LocalProjectArtefactImpl;
import org.openl.rules.workspace.lw.impl.StateHolder;
import org.openl.rules.workspace.props.PropertyException;

public class LocalProjectResourceImpl
extends LocalProjectArtefactImpl
implements LocalProjectResource {
    private static final Log log = LogFactory.getLog(LocalProjectResourceImpl.class);
    public static final int DOWNLOAD_BUFFER_SIZE = 8192;
    private String resourceType = "unknown";
    private long lastModified;

    public LocalProjectResourceImpl(String name, ArtefactPath path, File location) {
        super(name, path, location);
    }

    protected void downloadArtefact(ProjectResource resource) throws ProjectException {
        super.downloadArtefact(resource);
        InputStream is = resource.getContent();
        this.setLocalContent(is);
        this.refresh();
    }

    public LocalProjectArtefact getArtefact(String name) throws ProjectException {
        throw new ProjectException("Cannot find project artefact ''{0}''", null, name);
    }

    public InputStream getContent() throws ProjectException {
        try {
            return new FileInputStream(this.getLocation());
        }
        catch (FileNotFoundException e) {
            throw new ProjectException("Failed to get content", e);
        }
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public StateHolder getState() {
        ResourceStateHolder state = new ResourceStateHolder();
        state.parent = super.getState();
        state.resourceType = this.resourceType;
        state.lastModified = this.lastModified;
        return state;
    }

    public boolean hasArtefact(String name) {
        return false;
    }

    public boolean isFolder() {
        return false;
    }

    public void refresh() {
        long lm = this.getLocation().lastModified();
        if (lm != this.lastModified) {
            this.setChanged(true);
            this.lastModified = lm;
        }
    }

    public void setContent(InputStream inputStream) throws ProjectException {
        this.setLocalContent(inputStream);
        this.setChanged(true);
    }

    protected void setLocalContent(InputStream is) throws ProjectException {
        FileOutputStream fos = null;
        try {
            int readed;
            fos = new FileOutputStream(this.getLocation());
            byte[] buffer = new byte[8192];
            while ((readed = is.read(buffer)) >= 0) {
                fos.write(buffer, 0, readed);
            }
        }
        catch (IOException e) {
            throw new ProjectException("Cannot transfer resource context!", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error((Object)"Cannot close resource output stream!", (Throwable)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"Cannot close resource input stream!", (Throwable)e);
                }
            }
        }
    }

    public void setState(StateHolder aState) throws PropertyException {
        ResourceStateHolder state = (ResourceStateHolder)aState;
        super.setState(state.parent);
        this.resourceType = state.resourceType;
        this.lastModified = state.lastModified;
    }

    private static class ResourceStateHolder
    implements StateHolder {
        private static final long serialVersionUID = -8202714450047051624L;
        StateHolder parent;
        String resourceType;
        long lastModified;

        private ResourceStateHolder() {
        }
    }
}

