/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.lw.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.impl.ArtefactPathImpl;
import org.openl.rules.workspace.lw.LocalProject;
import org.openl.rules.workspace.lw.LocalWorkspace;
import org.openl.rules.workspace.lw.LocalWorkspaceListener;
import org.openl.rules.workspace.lw.impl.LocalProjectImpl;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.util.MsgHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalWorkspaceImpl
implements LocalWorkspace {
    private static final Log log = LogFactory.getLog(LocalWorkspaceImpl.class);
    private WorkspaceUser user;
    private File location;
    private Map<String, LocalProject> localProjects;
    private List<LocalWorkspaceListener> listeners = new ArrayList<LocalWorkspaceListener>();
    private FileFilter localWorkspaceFolderFilter;
    private FileFilter localWorkspaceFileFilter;
    private UserWorkspace userWorkspace;

    public LocalWorkspaceImpl(WorkspaceUser user, File location, FileFilter localWorkspaceFolderFilter, FileFilter localWorkspaceFileFilter) {
        this.user = user;
        this.location = location;
        this.localWorkspaceFolderFilter = localWorkspaceFolderFilter;
        this.localWorkspaceFileFilter = localWorkspaceFileFilter;
        this.localProjects = new HashMap<String, LocalProject>();
        this.loadProjects();
    }

    @Override
    public LocalProject addProject(Project project) throws ProjectException {
        String name = project.getName();
        if (this.hasProject(name)) {
            this.getProject(name).remove();
        }
        return this.downloadProject(project);
    }

    @Override
    public void addWorkspaceListener(LocalWorkspaceListener listener) {
        this.listeners.add(listener);
    }

    protected LocalProjectImpl downloadProject(Project project) throws ProjectException {
        String name = project.getName();
        ArtefactPathImpl ap = new ArtefactPathImpl(new String[]{name});
        File f = new File(this.location, name);
        LocalProjectImpl lpi = new LocalProjectImpl(name, ap, f, this, this.localWorkspaceFileFilter);
        lpi.downloadArtefact(project);
        lpi.save();
        this.localProjects.put(name, lpi);
        return lpi;
    }

    @Override
    public ProjectArtefact getArtefactByPath(ArtefactPath artefactPath) throws ProjectException {
        String projectName = artefactPath.segment(0);
        LocalProject lp = this.getProject(projectName);
        ArtefactPath pathInProject = artefactPath.withoutFirstSegment();
        return lp.getArtefactByPath(pathInProject);
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public LocalProject getProject(String name) throws ProjectException {
        LocalProject lp = this.localProjects.get(name);
        if (lp == null) {
            throw new ProjectException("Cannot find project ''{0}''!", null, name);
        }
        return lp;
    }

    @Override
    public Collection<LocalProject> getProjects() {
        return this.localProjects.values();
    }

    protected WorkspaceUser getUser() {
        return this.user;
    }

    @Override
    public boolean hasProject(String name) {
        return this.localProjects.get(name) != null;
    }

    private boolean isLocalOnly(LocalProject lp) {
        if (this.userWorkspace == null) {
            return false;
        }
        try {
            return ((UserWorkspaceProject)this.userWorkspace.getProject(lp.getName())).isLocalOnly();
        }
        catch (ProjectException e) {
            return false;
        }
    }

    protected void loadProjects() {
        File[] folders;
        for (File f : folders = this.location.listFiles(this.localWorkspaceFolderFilter)) {
            String name = f.getName();
            ArtefactPathImpl ap = new ArtefactPathImpl(new String[]{name});
            LocalProjectImpl lpi = new LocalProjectImpl(name, ap, f, this, this.localWorkspaceFileFilter);
            try {
                lpi.load();
            }
            catch (ProjectException e) {
                log.error((Object)MsgHelper.format((String)"Error loading local project ''{0}''!", (Object[])new Object[]{lpi.getName()}), (Throwable)e);
            }
            this.localProjects.put(name, lpi);
        }
    }

    protected void notifyRemoved(LocalProject project) {
        this.localProjects.remove(project.getName());
    }

    @Override
    public void refresh() {
        Iterator<LocalProject> i = this.localProjects.values().iterator();
        while (i.hasNext()) {
            LocalProjectImpl lp = (LocalProjectImpl)i.next();
            File location = lp.getLocation();
            if (location.exists()) {
                lp.refresh();
                continue;
            }
            i.remove();
        }
        File[] folders = this.location.listFiles(this.localWorkspaceFolderFilter);
        if (folders == null) {
            return;
        }
        for (File folder : folders) {
            String name = folder.getName();
            if (this.localProjects.containsKey(name)) continue;
            ArtefactPathImpl ap = new ArtefactPathImpl(new String[]{name});
            LocalProjectImpl newlyDetected = new LocalProjectImpl(name, ap, folder, this, this.localWorkspaceFileFilter);
            try {
                newlyDetected.load();
            }
            catch (ProjectException e) {
                String msg = MsgHelper.format((String)"Error loading just detected local project ''{0}''!", (Object[])new Object[]{name});
                log.error((Object)msg, (Throwable)e);
            }
            this.localProjects.put(name, newlyDetected);
        }
    }

    @Override
    public void release() {
        this.saveAll();
        this.localProjects.clear();
        this.userWorkspace = null;
        for (LocalWorkspaceListener lwl : this.listeners) {
            lwl.workspaceReleased(this);
        }
    }

    @Override
    public void removeProject(String name) throws ProjectException {
        this.getProject(name).remove();
    }

    @Override
    public boolean removeWorkspaceListener(LocalWorkspaceListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void saveAll() {
        for (LocalProject lp : this.localProjects.values()) {
            if (this.isLocalOnly(lp)) continue;
            try {
                lp.save();
            }
            catch (ProjectException e) {
                String msg = MsgHelper.format((String)"Error saving local project ''{0}''!", (Object[])new Object[]{lp.getName()});
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    @Override
    public void setUserWorkspace(UserWorkspace userWorkspace) {
        this.userWorkspace = userWorkspace;
    }
}

