/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.lw.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.workspace.WorkspaceException;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.lw.LocalWorkspace;
import org.openl.rules.workspace.lw.LocalWorkspaceListener;
import org.openl.rules.workspace.lw.LocalWorkspaceManager;
import org.openl.rules.workspace.lw.impl.FolderHelper;
import org.openl.rules.workspace.lw.impl.LocalWorkspaceImpl;
import org.openl.util.MsgHelper;
import org.springframework.beans.factory.InitializingBean;

public class LocalWorkspaceManagerImpl
implements LocalWorkspaceManager,
LocalWorkspaceListener,
InitializingBean {
    private static final Log log = LogFactory.getLog(LocalWorkspaceManagerImpl.class);
    private String workspacesRoot = "/tmp/rules-workspaces/";
    private boolean autoLogin = false;
    private FileFilter localWorkspaceFolderFilter;
    private FileFilter localWorkspaceFileFilter;
    private Map<String, LocalWorkspaceImpl> localWorkspaces = new HashMap<String, LocalWorkspaceImpl>();

    public void afterPropertiesSet() throws Exception {
        if (!FolderHelper.checkOrCreateFolder(new File(this.workspacesRoot))) {
            throw new WorkspaceException("Cannot create workspace location ''{0}''", null, this.workspacesRoot);
        }
        log.info((Object)("Location of Local Workspaces: " + this.workspacesRoot));
        log.info((Object)("Allow local user:" + this.autoLogin));
    }

    protected LocalWorkspaceImpl createEclipseWorkspace(WorkspaceUser user) throws WorkspaceException {
        String eclipseWorkspacePath = System.getProperty("openl.webstudio.home");
        if (eclipseWorkspacePath == null) {
            eclipseWorkspacePath = "..";
        }
        log.debug((Object)MsgHelper.format((String)"Referencing eclipse workspace for user ''{0}'' at ''{1}''", (Object[])new Object[]{user.getUserId(), eclipseWorkspacePath}));
        return new LocalWorkspaceImpl(user, new File(eclipseWorkspacePath), this.localWorkspaceFolderFilter, this.localWorkspaceFileFilter);
    }

    protected LocalWorkspaceImpl createWorkspace(WorkspaceUser user) throws WorkspaceException {
        String userId = user.getUserId();
        File f = FolderHelper.generateSubLocation(new File(this.workspacesRoot), userId);
        if (!FolderHelper.checkOrCreateFolder(f)) {
            throw new WorkspaceException("Cannot create folder ''{0}'' for local workspace!", null, f.getAbsolutePath());
        }
        log.debug((Object)MsgHelper.format((String)"Creating workspace for user ''{0}'' at ''{1}''", (Object[])new Object[]{user.getUserId(), f.getAbsolutePath()}));
        return new LocalWorkspaceImpl(user, f, this.localWorkspaceFolderFilter, this.localWorkspaceFileFilter);
    }

    public LocalWorkspace getWorkspace(WorkspaceUser user) throws WorkspaceException {
        String userId = user.getUserId();
        LocalWorkspaceImpl lwi = this.localWorkspaces.get(userId);
        if (lwi == null) {
            lwi = this.autoLogin && "LOCAL".equals(userId) ? this.createEclipseWorkspace(user) : this.createWorkspace(user);
            this.localWorkspaces.put(userId, lwi);
        }
        return lwi;
    }

    public void setAutoLogin(boolean autoLogin) {
        this.autoLogin = autoLogin;
    }

    public void setLocalWorkspaceFileFilter(FileFilter localWorkspaceFileFilter) {
        this.localWorkspaceFileFilter = localWorkspaceFileFilter;
    }

    public void setLocalWorkspaceFolderFilter(FileFilter localWorkspaceFolderFilter) {
        this.localWorkspaceFolderFilter = localWorkspaceFolderFilter;
    }

    public void setWorkspacesRoot(String workspacesRoot) {
        this.workspacesRoot = workspacesRoot;
    }

    public void workspaceReleased(LocalWorkspace workspace) {
        this.localWorkspaces.remove(((LocalWorkspaceImpl)workspace).getUser().getUserId());
    }
}

