/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.lw.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectFolder;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.rules.workspace.lw.LocalProjectArtefact;
import org.openl.rules.workspace.lw.impl.FolderHelper;
import org.openl.rules.workspace.lw.impl.LocalProjectArtefactImpl;
import org.openl.rules.workspace.lw.impl.LocalProjectFolderImpl;
import org.openl.rules.workspace.lw.impl.LocalProjectImpl;
import org.openl.rules.workspace.lw.impl.StateHolder;
import org.openl.util.MsgHelper;

class StatePersistance {
    private static final Log log = LogFactory.getLog(StatePersistance.class);
    private final LocalProjectImpl project;
    private final File propertiesLocation;

    private static void createFolderThrowing(File folder) throws ProjectException {
        FolderHelper.checkOrCreateFolder(folder);
        if (!folder.exists()) {
            throw new ProjectException("Could not create properties folder ''{0}''!", null, folder.getAbsolutePath());
        }
    }

    StatePersistance(LocalProjectImpl project) {
        this.project = project;
        this.propertiesLocation = new File(project.getLocation(), ".studioProps");
    }

    private File getPropertiesFile(ProjectFolder folder) {
        return new File(this.propertiesLocation, folder.getArtefactPath().getStringValue(1) + "/..studioProps.folder");
    }

    private File getPropertiesFile(ProjectResource resource) {
        return new File(this.propertiesLocation, resource.getArtefactPath().getStringValue(1) + ".props");
    }

    void load() {
        if (this.propertiesLocation.exists()) {
            this.loadAllStates(this.project);
        }
    }

    private void loadAllStates(LocalProjectFolderImpl folder) {
        this.loadState(folder, this.getPropertiesFile(folder));
        for (LocalProjectArtefact artefact : folder.getArtefacts()) {
            if (artefact.isFolder()) {
                LocalProjectFolderImpl localFolder = (LocalProjectFolderImpl)artefact;
                this.loadAllStates(localFolder);
                continue;
            }
            LocalProjectArtefactImpl localProjectArtefact = (LocalProjectArtefactImpl)artefact;
            this.loadState(localProjectArtefact, this.getPropertiesFile((ProjectResource)((Object)localProjectArtefact)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadState(LocalProjectArtefactImpl artefact, File sourceFile) {
        if (!sourceFile.isFile()) {
            return;
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(sourceFile));
            StateHolder state = (StateHolder)ois.readObject();
            artefact.setState(state);
        }
        catch (Exception e) {
            String msg = MsgHelper.format((String)"Could not read state from file ''{0}''!", (Object[])new Object[]{sourceFile.getAbsolutePath()});
            log.error((Object)msg, (Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    void save() throws ProjectException {
        StatePersistance.createFolderThrowing(this.propertiesLocation);
        this.saveAllStates(this.project);
    }

    private void saveAllStates(LocalProjectFolderImpl folder) throws ProjectException {
        this.saveState(folder, this.getPropertiesFile(folder));
        for (LocalProjectArtefact artefact : folder.getArtefacts()) {
            if (artefact.isFolder()) {
                LocalProjectFolderImpl localFolder = (LocalProjectFolderImpl)artefact;
                this.saveAllStates(localFolder);
                continue;
            }
            LocalProjectArtefactImpl localProjectArtefact = (LocalProjectArtefactImpl)artefact;
            this.saveState(localProjectArtefact, this.getPropertiesFile((ProjectResource)((Object)localProjectArtefact)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState(LocalProjectArtefactImpl artefact, File destFile) {
        File folder = destFile.getParentFile();
        if (!FolderHelper.checkOrCreateFolder(folder)) {
            String msg = MsgHelper.format((String)"Could not create folder ''{0}''!", (Object[])new Object[]{folder.getAbsolutePath()});
            log.error((Object)msg);
            return;
        }
        StateHolder state = artefact.getState();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(destFile));
            oos.writeObject(state);
            oos.flush();
        }
        catch (IOException e) {
            String msg = MsgHelper.format((String)"Could not save state into file ''{0}''!", (Object[])new Object[]{destFile.getAbsolutePath()});
            log.error((Object)msg, (Throwable)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

