/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.production.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.openl.rules.repository.ProductionRepositoryFactoryProxy;
import org.openl.rules.repository.RDeploymentListener;
import org.openl.rules.repository.RFile;
import org.openl.rules.repository.RFolder;
import org.openl.rules.repository.RProductionDeployment;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.workspace.deploy.DeployID;
import org.openl.rules.workspace.lw.impl.FolderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrRulesClient {
    public void addListener(RDeploymentListener l) throws RRepositoryException {
        ProductionRepositoryFactoryProxy.getRepositoryInstance().addListener(l);
    }

    private void download(RFolder folder, File location) throws RRepositoryException, IOException {
        location.mkdirs();
        for (RFile rFile : folder.getFiles()) {
            FileOutputStream os = new FileOutputStream(new File(location, rFile.getName()));
            IOUtils.copy((InputStream)rFile.getContent(), (OutputStream)os);
            IOUtils.closeQuietly((OutputStream)os);
        }
        for (RFolder rFolder : folder.getFolders()) {
            this.download(rFolder, new File(location, rFolder.getName()));
        }
    }

    public void fetchDeployment(DeployID deployID, File destFolder) throws Exception {
        destFolder.mkdirs();
        FolderHelper.clearFolder(destFolder);
        RProductionDeployment rDeployment = ProductionRepositoryFactoryProxy.getRepositoryInstance().getDeployment(deployID.getName());
        Collection projects = rDeployment.getProjects();
        for (RProject project : projects) {
            File projectFolder = new File(destFolder, project.getName());
            projectFolder.mkdirs();
            this.download(project.getRootFolder(), projectFolder);
        }
    }

    public Collection<String> getDeploymentNames() throws RRepositoryException {
        return ProductionRepositoryFactoryProxy.getRepositoryInstance().getDeploymentNames();
    }

    public void release() throws RRepositoryException {
        ProductionRepositoryFactoryProxy.release();
    }

    public void removeListener(RDeploymentListener l) throws RRepositoryException {
        ProductionRepositoryFactoryProxy.getRepositoryInstance().removeListener(l);
    }
}

