/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.props.impl;

import java.util.Collection;
import java.util.HashMap;
import org.openl.rules.workspace.props.PropertiesContainer;
import org.openl.rules.workspace.props.Property;
import org.openl.rules.workspace.props.PropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesContainerImpl
implements PropertiesContainer {
    private HashMap<String, Property> properties = new HashMap();

    @Override
    public void addProperty(Property property) throws PropertyException {
        String name = property.getName();
        Property existing = this.properties.get(name);
        if (existing == null) {
            this.properties.put(name, property);
        } else {
            switch (property.getType()) {
                case DATE: {
                    existing.setValue(property.getDate());
                    break;
                }
                case STRING: {
                    existing.setValue(property.getString());
                    break;
                }
                default: {
                    existing.setValue(property.getString());
                }
            }
        }
    }

    @Override
    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    @Override
    public Property getProperty(String name) throws PropertyException {
        Property property = this.properties.get(name);
        if (property == null) {
            throw new PropertyException("No such property ''{0}''", null, name);
        }
        return property;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void removeAll() {
        this.properties.clear();
    }

    @Override
    public Property removeProperty(String name) throws PropertyException {
        Property prop = this.getProperty(name);
        this.properties.remove(name);
        return prop;
    }
}

