/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.uw.impl;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.security.SecurityUtils;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectDependency;
import org.openl.rules.workspace.abstracts.ProjectDescriptor;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.abstracts.impl.ArtefactPathImpl;
import org.openl.rules.workspace.dtr.LockInfo;
import org.openl.rules.workspace.dtr.RepositoryDDProject;
import org.openl.rules.workspace.props.Property;
import org.openl.rules.workspace.props.PropertyException;
import org.openl.rules.workspace.uw.UserWorkspaceDeploymentProject;
import org.openl.rules.workspace.uw.UserWorkspaceProjectArtefact;
import org.openl.rules.workspace.uw.UserWorkspaceProjectFolder;
import org.openl.rules.workspace.uw.UserWorkspaceProjectResource;
import org.openl.rules.workspace.uw.impl.UserWorkspaceImpl;
import org.openl.rules.workspace.uw.impl.UserWorkspaceProjectDescriptorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserWorkspaceDeploymentProjectImpl
implements UserWorkspaceDeploymentProject {
    private UserWorkspaceImpl userWorkspace;
    private RepositoryDDProject dtrDProject;
    private RepositoryDDProject activeProjectVersion;
    private String name;
    private ArtefactPath path;
    private HashMap<String, ProjectDescriptor> descriptors;

    protected UserWorkspaceDeploymentProjectImpl(UserWorkspaceImpl userWorkspace, RepositoryDDProject dtrDProject) {
        this.userWorkspace = userWorkspace;
        this.dtrDProject = dtrDProject;
        this.name = dtrDProject.getName();
        this.path = new ArtefactPathImpl(new String[]{this.name});
        this.activeProjectVersion = dtrDProject;
        this.descriptors = new HashMap();
        this.refresh();
    }

    @Override
    public UserWorkspaceProjectFolder addFolder(String name) throws ProjectException {
        this.notSupported();
        return null;
    }

    @Override
    public ProjectDescriptor addProjectDescriptor(String name, CommonVersion version) throws ProjectException {
        UserWorkspaceProjectDescriptorImpl uwpd = new UserWorkspaceProjectDescriptorImpl(this, name, version);
        this.descriptors.put(name, uwpd);
        return uwpd;
    }

    @Override
    public void addProperty(Property property) throws PropertyException {
        this.notSupportedProps();
    }

    @Override
    public UserWorkspaceProjectResource addResource(String name, ProjectResource resource) throws ProjectException {
        this.notSupported();
        return null;
    }

    @Override
    public void checkIn() throws ProjectException {
        this.checkIn(0, 0);
    }

    @Override
    public void checkIn(int major, int minor) throws ProjectException {
        if (!this.isCheckedOut()) {
            throw new ProjectException("Project ''{0}'' must be checked-out before checking-in", null, this.getName());
        }
        if (major != 0 || minor != 0) {
            this.activeProjectVersion.riseVersion(major, minor);
        }
        this.activeProjectVersion.commit(this, this.userWorkspace.getUser());
        this.activeProjectVersion.unlock(this.userWorkspace.getUser());
        this.refresh();
    }

    @Override
    public void checkOut() throws ProjectException {
        if (this.isCheckedOut()) {
            throw new ProjectException("Project ''{0}'' is already checked-out", null, this.getName());
        }
        if (this.isLocked()) {
            throw new ProjectException("Project ''{0}'' is locked by ''{1}'' since ''{2}''", null, this.getName(), this.activeProjectVersion.getlLockInfo().getLockedBy().getUserName(), this.activeProjectVersion.getlLockInfo().getLockedAt());
        }
        SecurityUtils.check((String)"EDIT_DEPLOYMENT_PROJECTS");
        if (this.isOpened()) {
            this.close();
        }
        this.activeProjectVersion.lock(this.userWorkspace.getUser());
        this.refresh();
    }

    @Override
    public void close() throws ProjectException {
        if (this.isLockedByMe()) {
            this.activeProjectVersion.unlock(this.userWorkspace.getUser());
        }
        this.activeProjectVersion = this.dtrDProject;
        this.refresh();
    }

    @Override
    public void delete() throws ProjectException {
        if (this.isLocked() && !this.isLockedByMe()) {
            throw new ProjectException("Cannot delete project ''{0}'' while it is locked by other user", null, this.getName());
        }
        SecurityUtils.check((String)"DELETE_DEPLOYMENT_PROJECTS");
        if (this.isOpened()) {
            this.close();
        }
        this.activeProjectVersion.delete(this.userWorkspace.getUser());
    }

    @Override
    public void erase() throws ProjectException {
        SecurityUtils.check((String)"ERASE_DEPLOYMENT_PROJECTS");
        this.activeProjectVersion.erase(this.userWorkspace.getUser());
    }

    @Override
    public File exportVersion(CommonVersion version) throws ProjectException {
        throw new ProjectException("Export isn't supported for deployment project!");
    }

    @Override
    public UserWorkspaceProjectArtefact getArtefact(String name) throws ProjectException {
        this.notSupported();
        return null;
    }

    @Override
    public ProjectArtefact getArtefactByPath(ArtefactPath artefactPath) throws ProjectException {
        this.notSupported();
        return null;
    }

    @Override
    public ArtefactPath getArtefactPath() {
        return this.path;
    }

    @Override
    public Collection<? extends UserWorkspaceProjectArtefact> getArtefacts() {
        return new LinkedList();
    }

    public boolean getCanCheckOut() {
        if (this.isCheckedOut() || this.isLocked()) {
            return false;
        }
        return SecurityUtils.isGranted((String)"EDIT_DEPLOYMENT_PROJECTS");
    }

    public boolean getCanDelete() {
        return (!this.isLocked() || this.isLockedByMe()) && SecurityUtils.isGranted((String)"DELETE_DEPLOYMENT_PROJECTS");
    }

    public boolean getCanDeploy() {
        return !this.isCheckedOut() && SecurityUtils.isGranted((String)"DEPLOY_DEPLOYMENT_PROJECTS");
    }

    public boolean getCanErase() {
        return this.isDeleted() && SecurityUtils.isGranted((String)"ERASE_DEPLOYMENT_PROJECTS");
    }

    public boolean getCanOpen() {
        return !this.isCheckedOut() && SecurityUtils.isGranted((String)"READ_PROJECTS");
    }

    public boolean getCanUndelete() {
        return this.isDeleted() && SecurityUtils.isGranted((String)"EDIT_DEPLOYMENT_PROJECTS");
    }

    @Override
    public Collection<ProjectDependency> getDependencies() {
        return new LinkedList<ProjectDependency>();
    }

    @Override
    public Date getEffectiveDate() {
        return null;
    }

    @Override
    public Date getExpirationDate() {
        return null;
    }

    @Override
    public String getLineOfBusiness() {
        return null;
    }

    @Override
    public LockInfo getLockInfo() {
        if (this.dtrDProject == null) {
            return null;
        }
        return this.dtrDProject.getlLockInfo();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UserWorkspaceDeploymentProjectImpl getProject() {
        return this;
    }

    @Override
    public ProjectDescriptor getProjectDescriptor(String name) throws ProjectException {
        ProjectDescriptor pd = this.descriptors.get(name);
        if (pd == null) {
            throw new ProjectException("Cannot find descriptor for project {0} in {1}", null, name, this.getName());
        }
        return pd;
    }

    @Override
    public Collection<ProjectDescriptor> getProjectDescriptors() {
        return this.descriptors.values();
    }

    @Override
    public Collection<Property> getProperties() {
        return null;
    }

    @Override
    public Property getProperty(String name) throws PropertyException {
        this.notSupportedProps();
        return null;
    }

    @Override
    public Map<String, Object> getProps() {
        return null;
    }

    @Override
    public ProjectVersion getVersion() {
        return this.activeProjectVersion.getVersion();
    }

    @Override
    public Collection<ProjectVersion> getVersions() {
        return this.dtrDProject.getVersions();
    }

    @Override
    public boolean hasArtefact(String name) {
        return false;
    }

    @Override
    public boolean hasProperty(String name) {
        return false;
    }

    @Override
    public boolean isCheckedOut() {
        WorkspaceUser lockedBy;
        return this.activeProjectVersion.isLocked() && (lockedBy = this.activeProjectVersion.getlLockInfo().getLockedBy()).equals(this.userWorkspace.getUser());
    }

    @Override
    public boolean isDeleted() {
        return this.activeProjectVersion.isMarkedForDeletion();
    }

    @Override
    public boolean isDeploymentProject() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isLocalOnly() {
        return false;
    }

    @Override
    public boolean isLocked() {
        return this.dtrDProject.isLocked();
    }

    public boolean isLockedByMe() {
        if (!this.isLocked()) {
            return false;
        }
        WorkspaceUser lockedBy = this.dtrDProject.getlLockInfo().getLockedBy();
        return lockedBy.equals(this.userWorkspace.getUser());
    }

    @Override
    public boolean isOpened() {
        return this.activeProjectVersion != this.dtrDProject || this.isCheckedOut();
    }

    @Override
    public boolean isOpenedOtherVersion() {
        ProjectVersion max;
        if (this.isCheckedOut()) {
            return false;
        }
        if (this.activeProjectVersion == this.dtrDProject) {
            return false;
        }
        ProjectVersion activeVersion = this.activeProjectVersion.getVersion();
        return !activeVersion.equals(max = this.dtrDProject.getVersion());
    }

    @Override
    public boolean isReadOnly() {
        return !this.isCheckedOut();
    }

    @Override
    public boolean isRulesProject() {
        return false;
    }

    protected void notSupported() throws ProjectException {
        throw new ProjectException("Not supported for deployment project");
    }

    protected void notSupportedProps() throws PropertyException {
        throw new PropertyException("Not supported for deployment project", null);
    }

    @Override
    public void open() throws ProjectException {
        if (this.isCheckedOut()) {
            throw new ProjectException("Project ''{0}'' is checked-out!", null, this.getName());
        }
        SecurityUtils.check((String)"READ_PROJECTS");
        if (this.isOpened()) {
            this.close();
        }
        this.activeProjectVersion = this.dtrDProject;
        this.refresh();
    }

    @Override
    public void openVersion(CommonVersion version) throws ProjectException {
        if (this.isCheckedOut()) {
            throw new ProjectException("Deployment Project ''{0}'' is checked-out", null, this.getName());
        }
        if (this.isOpened()) {
            this.close();
        }
        this.activeProjectVersion = this.userWorkspace.getDDProjectFor(this.dtrDProject, version);
        this.refresh();
    }

    protected void refresh() {
        this.updateDescriptors(this.activeProjectVersion.getProjectDescriptors());
    }

    protected void removeProjectDescriptor(UserWorkspaceProjectDescriptorImpl pd) {
        this.descriptors.remove(pd.getProjectName());
    }

    @Override
    public Property removeProperty(String name) throws PropertyException {
        this.notSupportedProps();
        return null;
    }

    @Override
    public void setDependencies(Collection<ProjectDependency> dependencies) {
    }

    @Override
    public void setEffectiveDate(Date date) throws ProjectException {
        this.notSupported();
    }

    @Override
    public void setExpirationDate(Date date) throws ProjectException {
        this.notSupported();
    }

    @Override
    public void setLineOfBusiness(String lineOfBusiness) throws ProjectException {
        this.notSupported();
    }

    @Override
    public void setProjectDescriptors(Collection<ProjectDescriptor> projectDescriptors) throws ProjectException {
        if (this.isReadOnly()) {
            throw new ProjectException("Cannot change deployment descriptor in read only mode");
        }
        this.updateDescriptors(projectDescriptors);
    }

    @Override
    public void setProps(Map<String, Object> props) throws ProjectException {
        this.notSupported();
    }

    @Override
    public void undelete() throws ProjectException {
        SecurityUtils.check((String)"EDIT_DEPLOYMENT_PROJECTS");
        this.activeProjectVersion.undelete(this.userWorkspace.getUser());
    }

    protected void updateArtefact(RepositoryDDProject repositoryDDProject) {
        if (this.isCheckedOut()) {
            return;
        }
        if (this.isOpened()) {
            this.dtrDProject = repositoryDDProject;
        } else {
            this.dtrDProject = repositoryDDProject;
            this.activeProjectVersion = repositoryDDProject;
            this.refresh();
        }
    }

    protected void updateDescriptors(Collection<ProjectDescriptor> projectDescriptors) {
        HashMap<String, UserWorkspaceProjectDescriptorImpl> descrs = new HashMap<String, UserWorkspaceProjectDescriptorImpl>();
        for (ProjectDescriptor pd : projectDescriptors) {
            String name = pd.getProjectName();
            UserWorkspaceProjectDescriptorImpl uwpd = new UserWorkspaceProjectDescriptorImpl(this, name, pd.getProjectVersion());
            descrs.put(name, uwpd);
        }
        this.descriptors.clear();
        this.descriptors = descrs;
    }
}

