/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.uw.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectDescriptor;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.deploy.DeployID;
import org.openl.rules.workspace.deploy.DeploymentException;
import org.openl.rules.workspace.deploy.ProductionDeployer;
import org.openl.rules.workspace.dtr.DesignTimeRepository;
import org.openl.rules.workspace.dtr.RepositoryDDProject;
import org.openl.rules.workspace.dtr.RepositoryException;
import org.openl.rules.workspace.dtr.RepositoryProject;
import org.openl.rules.workspace.lw.LocalProject;
import org.openl.rules.workspace.lw.LocalWorkspace;
import org.openl.rules.workspace.uw.UserWorkspace;
import org.openl.rules.workspace.uw.UserWorkspaceDeploymentProject;
import org.openl.rules.workspace.uw.UserWorkspaceListener;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.rules.workspace.uw.impl.ProjectExportHelper;
import org.openl.rules.workspace.uw.impl.UserWorkspaceDeploymentProjectImpl;
import org.openl.rules.workspace.uw.impl.UserWorkspaceProjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserWorkspaceImpl
implements UserWorkspace {
    private static final Log log = LogFactory.getLog(UserWorkspaceImpl.class);
    private static final Comparator<UserWorkspaceProject> PROJECTS_COMPARATOR = new Comparator<UserWorkspaceProject>(){

        @Override
        public int compare(UserWorkspaceProject o1, UserWorkspaceProject o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final WorkspaceUser user;
    private final LocalWorkspace localWorkspace;
    private final DesignTimeRepository designTimeRepository;
    private final ProductionDeployer deployer;
    private final HashMap<String, UserWorkspaceProject> userRulesProjects;
    private final HashMap<String, UserWorkspaceDeploymentProject> userDProjects;
    private final List<UserWorkspaceListener> listeners = new ArrayList<UserWorkspaceListener>();

    public UserWorkspaceImpl(WorkspaceUser user, LocalWorkspace localWorkspace, DesignTimeRepository designTimeRepository, ProductionDeployer deployer) {
        this.user = user;
        this.localWorkspace = localWorkspace;
        this.designTimeRepository = designTimeRepository;
        this.deployer = deployer;
        this.userRulesProjects = new HashMap();
        this.userDProjects = new HashMap();
        localWorkspace.setUserWorkspace(this);
    }

    @Override
    public void activate() throws ProjectException {
        this.refresh();
    }

    @Override
    public void addWorkspaceListener(UserWorkspaceListener listener) {
        this.listeners.add(listener);
    }

    protected void checkInProject(LocalProject localProject, int major, int minor) throws RepositoryException {
        this.designTimeRepository.updateProject(localProject, this.user, major, minor);
    }

    @Override
    public void copyDDProject(UserWorkspaceDeploymentProject project, String name) throws ProjectException {
        this.designTimeRepository.copyDDProject(project, name, this.user);
        this.refresh();
    }

    @Override
    public void copyProject(UserWorkspaceProject project, String name) throws ProjectException {
        this.designTimeRepository.copyProject(project, name, this.user);
        this.refresh();
    }

    @Override
    public void createDDProject(String name) throws RepositoryException {
        this.designTimeRepository.createDDProject(name);
    }

    @Override
    public void createProject(String name) throws ProjectException {
        this.designTimeRepository.createProject(name);
        this.refresh();
    }

    @Override
    public DeployID deploy(UserWorkspaceDeploymentProject deploymentProject) throws DeploymentException, RepositoryException {
        Collection<ProjectDescriptor> projectDescriptors = deploymentProject.getProjectDescriptors();
        ArrayList<RepositoryProject> projects = new ArrayList<RepositoryProject>();
        for (ProjectDescriptor descriptor : projectDescriptors) {
            projects.add(this.designTimeRepository.getProject(descriptor.getProjectName(), descriptor.getProjectVersion()));
        }
        DeployID id = new DeployID(deploymentProject.getName() + "#" + deploymentProject.getVersion().getVersionName());
        this.deployer.deploy(id, projects);
        return id;
    }

    protected File exportProject(RepositoryProject repositoryProject, CommonVersion version) throws ProjectException {
        RepositoryProject oldRP = this.designTimeRepository.getProject(repositoryProject.getName(), version);
        ProjectExportHelper exportHelper = new ProjectExportHelper();
        return exportHelper.export(this.user, oldRP);
    }

    @Override
    public ProjectArtefact getArtefactByPath(ArtefactPath artefactPath) throws ProjectException {
        String projectName = artefactPath.segment(0);
        UserWorkspaceProject uwp = this.getProject(projectName);
        ArtefactPath pathInProject = artefactPath.withoutFirstSegment();
        return uwp.getArtefactByPath(pathInProject);
    }

    @Override
    public UserWorkspaceDeploymentProject getDDProject(String name) throws RepositoryException {
        try {
            RepositoryDDProject ddp = this.designTimeRepository.getDDProject(name);
            UserWorkspaceDeploymentProject userDProject = this.userDProjects.get(name);
            if (userDProject == null) {
                userDProject = new UserWorkspaceDeploymentProjectImpl(this, ddp);
                this.userDProjects.put(name, userDProject);
            }
            return userDProject;
        }
        catch (RepositoryException e) {
            this.userDProjects.remove(name);
            throw e;
        }
    }

    protected RepositoryDDProject getDDProjectFor(RepositoryDDProject deploymentProject, CommonVersion version) throws ProjectException {
        RepositoryDDProject oldDP = this.designTimeRepository.getDDProject(deploymentProject.getName(), version);
        return oldDP;
    }

    @Override
    public List<UserWorkspaceDeploymentProject> getDDProjects() throws RepositoryException {
        this.refreshDeploymentProjects();
        ArrayList<UserWorkspaceDeploymentProject> result = new ArrayList<UserWorkspaceDeploymentProject>(this.userDProjects.values());
        Collections.sort(result, PROJECTS_COMPARATOR);
        return result;
    }

    @Override
    public DesignTimeRepository getDesignTimeRepository() {
        return this.designTimeRepository;
    }

    @Override
    public File getLocalWorkspaceLocation() {
        return this.localWorkspace.getLocation();
    }

    @Override
    public UserWorkspaceProject getProject(String name) throws ProjectException {
        this.refreshRulesProjects();
        UserWorkspaceProject uwp = this.userRulesProjects.get(name);
        if (uwp == null) {
            throw new ProjectException("Cannot find project ''{0}''", null, name);
        }
        return uwp;
    }

    @Override
    public Collection<UserWorkspaceProject> getProjects() {
        try {
            this.refreshRulesProjects();
        }
        catch (ProjectException e) {
            log.error((Object)"Failed to resfresh projects!", (Throwable)e);
        }
        ArrayList<UserWorkspaceProject> result = new ArrayList<UserWorkspaceProject>(this.userRulesProjects.values());
        Collections.sort(result, PROJECTS_COMPARATOR);
        return result;
    }

    public WorkspaceUser getUser() {
        return this.user;
    }

    @Override
    public boolean hasDDProject(String name) {
        if (this.userDProjects.get(name) != null) {
            return true;
        }
        return this.designTimeRepository.hasDDProject(name);
    }

    @Override
    public boolean hasProject(String name) {
        if (this.userRulesProjects.get(name) != null) {
            return true;
        }
        if (this.localWorkspace.hasProject(name)) {
            return true;
        }
        return this.designTimeRepository.hasProject(name);
    }

    protected LocalProject openLocalProjectFor(RepositoryProject repositoryProject) throws ProjectException {
        return this.localWorkspace.addProject(repositoryProject);
    }

    protected LocalProject openLocalProjectFor(RepositoryProject repositoryProject, CommonVersion version) throws ProjectException {
        RepositoryProject oldRP = this.designTimeRepository.getProject(repositoryProject.getName(), version);
        return this.localWorkspace.addProject(oldRP);
    }

    @Override
    public void passivate() {
        this.localWorkspace.saveAll();
        this.userRulesProjects.clear();
    }

    @Override
    public void refresh() throws ProjectException {
        this.refreshRulesProjects();
        this.refreshDeploymentProjects();
    }

    protected void refreshDeploymentProjects() throws RepositoryException {
        String name;
        List<RepositoryDDProject> dtrProjects = this.designTimeRepository.getDDProjects();
        HashMap<String, RepositoryDDProject> dtrProjectsMap = new HashMap<String, RepositoryDDProject>();
        for (RepositoryDDProject ddp : dtrProjects) {
            name = ddp.getName();
            dtrProjectsMap.put(name, ddp);
            UserWorkspaceDeploymentProjectImpl userDProject = (UserWorkspaceDeploymentProjectImpl)this.userDProjects.get(name);
            if (userDProject == null) {
                userDProject = new UserWorkspaceDeploymentProjectImpl(this, ddp);
                this.userDProjects.put(name, userDProject);
                continue;
            }
            userDProject.updateArtefact(ddp);
        }
        Iterator<UserWorkspaceDeploymentProject> i = this.userDProjects.values().iterator();
        while (i.hasNext()) {
            UserWorkspaceDeploymentProject userDProject = i.next();
            name = userDProject.getName();
            if (dtrProjectsMap.containsKey(name)) continue;
            i.remove();
        }
    }

    protected void refreshRulesProjects() throws RepositoryException {
        String name;
        this.localWorkspace.refresh();
        for (RepositoryProject rp : this.designTimeRepository.getProjects()) {
            UserWorkspaceProjectImpl uwp;
            name = rp.getName();
            LocalProject lp = null;
            if (this.localWorkspace.hasProject(name)) {
                try {
                    lp = (LocalProject)this.localWorkspace.getProject(name);
                }
                catch (ProjectException e) {
                    log.error((Object)"refreshRulesProjects", (Throwable)e);
                }
            }
            if ((uwp = (UserWorkspaceProjectImpl)this.userRulesProjects.get(name)) == null) {
                uwp = new UserWorkspaceProjectImpl(this, lp, rp);
                this.userRulesProjects.put(name, uwp);
                continue;
            }
            if (!uwp.isLocalOnly()) continue;
            uwp.updateArtefact(lp, rp);
        }
        for (LocalProject lp : this.localWorkspace.getProjects()) {
            name = lp.getName();
            if (this.designTimeRepository.hasProject(name)) continue;
            UserWorkspaceProjectImpl uwp = (UserWorkspaceProjectImpl)this.userRulesProjects.get(name);
            if (uwp == null) {
                uwp = new UserWorkspaceProjectImpl(this, lp, null);
                this.userRulesProjects.put(name, uwp);
                continue;
            }
            uwp.updateArtefact(lp, null);
        }
        Iterator<Map.Entry<String, UserWorkspaceProject>> entryIterator = this.userRulesProjects.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, UserWorkspaceProject> entry = entryIterator.next();
            if (this.designTimeRepository.hasProject(entry.getKey()) || this.localWorkspace.hasProject(entry.getKey())) continue;
            entryIterator.remove();
        }
    }

    @Override
    public void release() {
        this.localWorkspace.release();
        this.userRulesProjects.clear();
        for (UserWorkspaceListener listener : this.listeners) {
            listener.workspaceReleased(this);
        }
    }

    @Override
    public boolean removeWorkspaceListener(UserWorkspaceListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void uploadLocalProject(String name) throws ProjectException {
        this.createProject(name);
        UserWorkspaceProjectImpl workspaceProject = (UserWorkspaceProjectImpl)this.getProject(name);
        workspaceProject.checkOutLocal();
        workspaceProject.checkIn();
    }
}

