/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.uw.impl;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.openl.rules.security.SecurityUtils;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.dtr.RepositoryProjectArtefact;
import org.openl.rules.workspace.lw.LocalProjectArtefact;
import org.openl.rules.workspace.props.Property;
import org.openl.rules.workspace.props.PropertyException;
import org.openl.rules.workspace.repository.RulesRepositoryArtefact;
import org.openl.rules.workspace.uw.UserWorkspaceProjectArtefact;
import org.openl.rules.workspace.uw.impl.UserWorkspaceProjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserWorkspaceProjectArtefactImpl
implements UserWorkspaceProjectArtefact {
    private UserWorkspaceProjectImpl project;
    private LocalProjectArtefact localArtefact;
    private RepositoryProjectArtefact dtrArtefact;

    protected UserWorkspaceProjectArtefactImpl(UserWorkspaceProjectImpl project, LocalProjectArtefact localArtefact, RepositoryProjectArtefact dtrArtefact) {
        this.project = project;
        this.updateArtefact(localArtefact, dtrArtefact);
    }

    @Override
    public void addProperty(Property property) throws PropertyException {
        this.getArtefact().addProperty(property);
    }

    protected ProjectArtefact getArtefact() {
        return this.isLocal() ? this.localArtefact : this.dtrArtefact;
    }

    @Override
    public ArtefactPath getArtefactPath() {
        return this.getArtefact().getArtefactPath();
    }

    public boolean getCanModify() {
        return !this.isReadOnly() && SecurityUtils.isGranted((String)"EDIT_PROJECTS");
    }

    @Override
    public Date getEffectiveDate() {
        RulesRepositoryArtefact rra = (RulesRepositoryArtefact)((Object)this.getArtefact());
        return rra.getEffectiveDate();
    }

    @Override
    public Date getExpirationDate() {
        RulesRepositoryArtefact rra = (RulesRepositoryArtefact)((Object)this.getArtefact());
        return rra.getExpirationDate();
    }

    @Override
    public String getLineOfBusiness() {
        RulesRepositoryArtefact rra = (RulesRepositoryArtefact)((Object)this.getArtefact());
        return rra.getLineOfBusiness();
    }

    @Override
    public String getName() {
        return this.getArtefact().getName();
    }

    public UserWorkspaceProjectImpl getProject() {
        return this.project;
    }

    @Override
    public Collection<Property> getProperties() {
        return this.getArtefact().getProperties();
    }

    @Override
    public Property getProperty(String name) throws PropertyException {
        return this.getArtefact().getProperty(name);
    }

    @Override
    public Map<String, Object> getProps() {
        RulesRepositoryArtefact rra = (RulesRepositoryArtefact)((Object)this.getArtefact());
        return rra.getProps();
    }

    @Override
    public Collection<ProjectVersion> getVersions() {
        if (this.dtrArtefact != null) {
            return this.dtrArtefact.getVersions();
        }
        return new LinkedList<ProjectVersion>();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getArtefact().hasProperty(name);
    }

    protected boolean isLocal() {
        return this.project.isLocal();
    }

    @Override
    public boolean isReadOnly() {
        return this.project.isReadOnly();
    }

    @Override
    public Property removeProperty(String name) throws PropertyException {
        return this.getArtefact().removeProperty(name);
    }

    @Override
    public void setEffectiveDate(Date date) throws ProjectException {
        if (this.isReadOnly()) {
            throw new ProjectException("Cannot set effectiveDate in read mode");
        }
        this.localArtefact.setEffectiveDate(date);
    }

    @Override
    public void setExpirationDate(Date date) throws ProjectException {
        if (this.isReadOnly()) {
            throw new ProjectException("Cannot set expirationDate in read mode");
        }
        this.localArtefact.setExpirationDate(date);
    }

    @Override
    public void setLineOfBusiness(String lineOfBusiness) throws ProjectException {
        if (this.isReadOnly()) {
            throw new ProjectException("Cannot set LOB in read mode");
        }
        this.localArtefact.setLineOfBusiness(lineOfBusiness);
    }

    protected void setProject(UserWorkspaceProjectImpl project) {
        this.project = project;
    }

    @Override
    public void setProps(Map<String, Object> props) throws ProjectException {
        if (this.isReadOnly()) {
            throw new ProjectException("Cannot set properties in read mode");
        }
        this.localArtefact.setProps(props);
    }

    protected void updateArtefact(LocalProjectArtefact localArtefact, RepositoryProjectArtefact dtrArtefact) {
        this.localArtefact = localArtefact;
        this.dtrArtefact = dtrArtefact;
    }
}

