/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.uw.impl;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectResource;
import org.openl.rules.workspace.dtr.RepositoryProjectArtefact;
import org.openl.rules.workspace.dtr.RepositoryProjectFolder;
import org.openl.rules.workspace.dtr.RepositoryProjectResource;
import org.openl.rules.workspace.lw.LocalProjectArtefact;
import org.openl.rules.workspace.lw.LocalProjectFolder;
import org.openl.rules.workspace.lw.LocalProjectResource;
import org.openl.rules.workspace.uw.UserWorkspaceProjectArtefact;
import org.openl.rules.workspace.uw.UserWorkspaceProjectFolder;
import org.openl.rules.workspace.uw.UserWorkspaceProjectResource;
import org.openl.rules.workspace.uw.impl.UserWorkspaceProjectArtefactImpl;
import org.openl.rules.workspace.uw.impl.UserWorkspaceProjectImpl;
import org.openl.rules.workspace.uw.impl.UserWorkspaceProjectResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserWorkspaceProjectFolderImpl
extends UserWorkspaceProjectArtefactImpl
implements UserWorkspaceProjectFolder {
    private static final Log log = LogFactory.getLog(UserWorkspaceProjectFolderImpl.class);
    private LocalProjectFolder localFolder;
    private RepositoryProjectFolder dtrFolder;

    protected UserWorkspaceProjectFolderImpl(UserWorkspaceProjectImpl project, LocalProjectFolder localFolder, RepositoryProjectFolder dtrFolder) {
        super(project, localFolder, dtrFolder);
        this.updateArtefact(localFolder, dtrFolder);
    }

    @Override
    public UserWorkspaceProjectFolder addFolder(String name) throws ProjectException {
        if (this.isReadOnly()) {
            throw new ProjectException("Cannot add folder ''{0}'' in read only mode", null, name);
        }
        LocalProjectFolder local = this.localFolder.addFolder(name);
        return this.wrapFolder(local, null);
    }

    @Override
    public UserWorkspaceProjectResource addResource(String name, ProjectResource resource) throws ProjectException {
        if (this.isReadOnly()) {
            throw new ProjectException("Cannot add resource ''{0}'' in read only mode", null, name);
        }
        LocalProjectResource local = this.localFolder.addResource(name, resource);
        return this.wrapFile(local, null);
    }

    @Override
    public void delete() throws ProjectException {
        if (this.isReadOnly()) {
            throw new ProjectException("Cannot delete in read only mode!", null);
        }
        this.localFolder.remove();
    }

    @Override
    public UserWorkspaceProjectArtefact getArtefact(String name) throws ProjectException {
        if (this.isLocal()) {
            return this.wrapLocalArtefact((LocalProjectArtefact)this.localFolder.getArtefact(name));
        }
        return this.wrapRepositoryArtefact((RepositoryProjectArtefact)this.dtrFolder.getArtefact(name));
    }

    @Override
    public Collection<? extends UserWorkspaceProjectArtefact> getArtefacts() {
        LinkedList<UserWorkspaceProjectArtefact> result = new LinkedList<UserWorkspaceProjectArtefact>();
        if (this.isLocal()) {
            for (LocalProjectArtefact lpa : this.localFolder.getArtefacts()) {
                result.add(this.wrapLocalArtefact(lpa));
            }
        } else {
            for (RepositoryProjectArtefact rpa : this.dtrFolder.getArtefacts()) {
                result.add(this.wrapRepositoryArtefact(rpa));
            }
        }
        return result;
    }

    @Override
    public boolean hasArtefact(String name) {
        if (this.isLocal()) {
            return this.localFolder.hasArtefact(name);
        }
        return this.dtrFolder.hasArtefact(name);
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    protected void updateArtefact(LocalProjectFolder localFolder, RepositoryProjectFolder dtrFolder) {
        super.updateArtefact(localFolder, dtrFolder);
        this.localFolder = localFolder;
        this.dtrFolder = dtrFolder;
    }

    protected UserWorkspaceProjectResource wrapFile(LocalProjectResource local, RepositoryProjectResource remote) {
        return new UserWorkspaceProjectResourceImpl(this.getProject(), local, remote);
    }

    protected UserWorkspaceProjectFolder wrapFolder(LocalProjectFolder local, RepositoryProjectFolder remote) {
        return new UserWorkspaceProjectFolderImpl(this.getProject(), local, remote);
    }

    protected UserWorkspaceProjectArtefact wrapLocalArtefact(LocalProjectArtefact lpa) {
        ProjectArtefact rpa = null;
        boolean isRemoteFolder = false;
        try {
            if (this.dtrFolder != null && this.dtrFolder.hasArtefact(lpa.getName())) {
                rpa = this.dtrFolder.getArtefact(lpa.getName());
                isRemoteFolder = rpa.isFolder();
            }
        }
        catch (ProjectException e) {
            log.error((Object)"wrapLocalArtefact", (Throwable)e);
        }
        if (lpa.isFolder()) {
            if (!isRemoteFolder) {
                rpa = null;
            }
            return this.wrapFolder((LocalProjectFolder)lpa, (RepositoryProjectFolder)rpa);
        }
        if (isRemoteFolder) {
            rpa = null;
        }
        return this.wrapFile((LocalProjectResource)lpa, (RepositoryProjectResource)rpa);
    }

    protected UserWorkspaceProjectArtefact wrapRepositoryArtefact(RepositoryProjectArtefact rpa) {
        if (rpa.isFolder()) {
            return this.wrapFolder(null, (RepositoryProjectFolder)rpa);
        }
        return this.wrapFile(null, (RepositoryProjectResource)rpa);
    }
}

