/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.workspace.uw.impl;

import java.io.File;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.security.SecurityUtils;
import org.openl.rules.workspace.WorkspaceUser;
import org.openl.rules.workspace.abstracts.ArtefactPath;
import org.openl.rules.workspace.abstracts.Project;
import org.openl.rules.workspace.abstracts.ProjectArtefact;
import org.openl.rules.workspace.abstracts.ProjectDependency;
import org.openl.rules.workspace.abstracts.ProjectException;
import org.openl.rules.workspace.abstracts.ProjectVersion;
import org.openl.rules.workspace.dtr.LockInfo;
import org.openl.rules.workspace.dtr.RepositoryProject;
import org.openl.rules.workspace.lw.LocalProject;
import org.openl.rules.workspace.uw.UserWorkspaceProject;
import org.openl.rules.workspace.uw.impl.UserWorkspaceImpl;
import org.openl.rules.workspace.uw.impl.UserWorkspaceProjectFolderImpl;
import org.openl.util.MsgHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserWorkspaceProjectImpl
extends UserWorkspaceProjectFolderImpl
implements UserWorkspaceProject {
    private static final Log log = LogFactory.getLog(UserWorkspaceProjectImpl.class);
    private Project project;
    private LocalProject localProject;
    private RepositoryProject dtrProject;
    private UserWorkspaceImpl userWorkspace;

    public UserWorkspaceProjectImpl(UserWorkspaceImpl userWorkspace, LocalProject localProject, RepositoryProject dtrProject) {
        super(null, localProject, dtrProject);
        this.setProject(this);
        this.userWorkspace = userWorkspace;
        this.updateArtefact(localProject, dtrProject);
    }

    @Override
    public void checkIn() throws ProjectException {
        this.checkIn(0, 0);
    }

    @Override
    public void checkIn(int major, int minor) throws ProjectException {
        if (!this.isCheckedOut()) {
            throw new ProjectException("Project ''{0}'' must be checked-out before checking-in!", null, this.getName());
        }
        this.userWorkspace.checkInProject(this.localProject, major, minor);
        this.dtrProject.unlock(this.userWorkspace.getUser());
        this.localProject.checkedIn(this.dtrProject.getVersion());
        this.dtrProject.update(this.localProject);
        this.updateArtefact(this.localProject, this.dtrProject);
    }

    @Override
    public void checkOut() throws ProjectException {
        if (this.isLocalOnly()) {
            throw new ProjectException("Project ''{0}'' cannot be checked out since it is local only!", null, this.getName());
        }
        if (this.isCheckedOut()) {
            throw new ProjectException("Project ''{0}'' is already checked-out!", null, this.getName());
        }
        if (this.isLocked()) {
            throw new ProjectException("Project ''{0}'' is locked by ''{1}'' since ''{2}''!", null, this.getName(), this.dtrProject.getlLockInfo().getLockedBy().getUserName(), this.dtrProject.getlLockInfo().getLockedAt());
        }
        SecurityUtils.check((String)"EDIT_PROJECTS");
        if (this.isOpened()) {
            this.close();
        }
        this.localProject = this.userWorkspace.openLocalProjectFor(this.dtrProject);
        this.dtrProject.lock(this.userWorkspace.getUser());
        this.updateArtefact(this.localProject, this.dtrProject);
    }

    protected void checkOutLocal() throws ProjectException {
        this.dtrProject.lock(this.userWorkspace.getUser());
    }

    @Override
    public void close() throws ProjectException {
        if (this.isLockedByMe()) {
            this.dtrProject.unlock(this.userWorkspace.getUser());
        }
        if (this.localProject != null) {
            this.localProject.remove();
        }
        this.updateArtefact(null, this.dtrProject);
    }

    @Override
    public void delete() throws ProjectException {
        if (this.isLocked() && !this.isLockedByMe()) {
            throw new ProjectException("Cannot delete project ''{0}'' while it is locked by other user!", null, this.getName());
        }
        SecurityUtils.check((String)"DELETE_PROJECTS");
        if (this.isOpened()) {
            this.close();
        }
        if (this.dtrProject != null) {
            this.dtrProject.delete(this.userWorkspace.getUser());
        }
    }

    @Override
    public void erase() throws ProjectException {
        SecurityUtils.check((String)"ERASE_PROJECTS");
        if (this.dtrProject != null) {
            this.dtrProject.erase(this.userWorkspace.getUser());
        }
    }

    @Override
    public File exportVersion(CommonVersion version) throws ProjectException {
        SecurityUtils.check((String)"READ_PROJECTS");
        return this.userWorkspace.exportProject(this.dtrProject, version);
    }

    @Override
    public ProjectArtefact getArtefactByPath(ArtefactPath artefactPath) throws ProjectException {
        return this.project.getArtefactByPath(artefactPath);
    }

    public boolean getCanCheckOut() {
        if (this.isLocalOnly() || this.isCheckedOut() || this.isLocked()) {
            return false;
        }
        return SecurityUtils.isGranted((String)"EDIT_PROJECTS");
    }

    public boolean getCanClose() {
        return !this.isLocalOnly() && this.isOpened();
    }

    public boolean getCanDelete() {
        if (this.isLocalOnly()) {
            return true;
        }
        return (!this.isLocked() || this.isLockedByMe()) && SecurityUtils.isGranted((String)"DELETE_PROJECTS");
    }

    public boolean getCanErase() {
        return this.isDeleted() && SecurityUtils.isGranted((String)"ERASE_PROJECTS");
    }

    public boolean getCanExport() {
        return this.getCanOpen();
    }

    public boolean getCanOpen() {
        if (this.isLocalOnly() || this.isCheckedOut()) {
            return false;
        }
        return SecurityUtils.isGranted((String)"READ_PROJECTS");
    }

    public boolean getCanCompare() {
        if (this.isLocalOnly()) {
            return false;
        }
        return SecurityUtils.isGranted((String)"READ_PROJECTS");
    }

    public boolean getCanRedeploy() {
        if (this.isLocalOnly() || this.isCheckedOut()) {
            return false;
        }
        return SecurityUtils.isGranted((String)"DEPLOY_DEPLOYMENT_PROJECTS");
    }

    public boolean getCanUndelete() {
        return this.isDeleted() && SecurityUtils.isGranted((String)"EDIT_PROJECTS");
    }

    @Override
    public Collection<ProjectDependency> getDependencies() {
        return this.project.getDependencies();
    }

    @Override
    public LockInfo getLockInfo() {
        if (this.dtrProject == null) {
            return null;
        }
        return this.dtrProject.getlLockInfo();
    }

    protected WorkspaceUser getUser() {
        return this.userWorkspace.getUser();
    }

    @Override
    public ProjectVersion getVersion() {
        return this.project.getVersion();
    }

    @Override
    public boolean isCheckedOut() {
        WorkspaceUser lockedBy;
        if (this.isLocalOnly()) {
            return false;
        }
        return this.dtrProject.isLocked() && (lockedBy = this.dtrProject.getlLockInfo().getLockedBy()).equals(this.userWorkspace.getUser());
    }

    @Override
    public boolean isDeleted() {
        if (this.isLocalOnly()) {
            return false;
        }
        return this.dtrProject.isMarkedForDeletion();
    }

    @Override
    public boolean isDeploymentProject() {
        return false;
    }

    @Override
    protected boolean isLocal() {
        return this.project == this.localProject;
    }

    @Override
    public boolean isLocalOnly() {
        return this.dtrProject == null;
    }

    @Override
    public boolean isLocked() {
        if (this.dtrProject == null) {
            return false;
        }
        return this.dtrProject.isLocked();
    }

    public boolean isLockedByMe() {
        if (!this.isLocked()) {
            return false;
        }
        WorkspaceUser lockedBy = this.dtrProject.getlLockInfo().getLockedBy();
        return lockedBy.equals(this.userWorkspace.getUser());
    }

    @Override
    public boolean isOpened() {
        return this.localProject != null;
    }

    @Override
    public boolean isOpenedOtherVersion() {
        if (!this.isOpened()) {
            return false;
        }
        Collection<ProjectVersion> versions = this.dtrProject.getVersions();
        ProjectVersion max = null;
        for (ProjectVersion version : versions) {
            if (max != null && max.compareTo(version) >= 0) continue;
            max = version;
        }
        return !this.getVersion().equals(max);
    }

    @Override
    public boolean isReadOnly() {
        return !this.isCheckedOut();
    }

    @Override
    public boolean isRulesProject() {
        return true;
    }

    @Override
    public void open() throws ProjectException {
        if (this.isLocalOnly()) {
            throw new ProjectException("Project ''{0}'' cannot be opened since it is local only!", null, this.getName());
        }
        if (this.isCheckedOut()) {
            throw new ProjectException("Project ''{0}'' is checked-out!", null, this.getName());
        }
        SecurityUtils.check((String)"READ_PROJECTS");
        if (this.isOpened()) {
            this.close();
        }
        this.localProject = this.userWorkspace.openLocalProjectFor(this.dtrProject);
        this.updateArtefact(this.localProject, this.dtrProject);
    }

    @Override
    public void openVersion(CommonVersion version) throws ProjectException {
        if (this.isCheckedOut() || this.isOpened()) {
            this.close();
        }
        SecurityUtils.check((String)"READ_PROJECTS");
        this.localProject = this.userWorkspace.openLocalProjectFor(this.dtrProject, version);
        this.updateArtefact(this.localProject, this.dtrProject);
    }

    @Override
    public void setDependencies(Collection<ProjectDependency> dependencies) throws ProjectException {
        if (this.isReadOnly()) {
            throw new ProjectException("Cannot change dependencies in read only mode!", null);
        }
        this.project.setDependencies(dependencies);
    }

    @Override
    public void undelete() throws ProjectException {
        SecurityUtils.check((String)"EDIT_PROJECTS");
        if (this.dtrProject != null) {
            this.dtrProject.undelete(this.userWorkspace.getUser());
        }
    }

    protected void updateArtefact(LocalProject localProject, RepositoryProject dtrProject) {
        super.updateArtefact(localProject, dtrProject);
        this.localProject = localProject;
        this.dtrProject = dtrProject;
        this.project = localProject == null ? dtrProject : localProject;
        if (this.isLockedByMe() && !this.isOpened()) {
            String msg = MsgHelper.format((String)"Project ''{0}'' is locked but not opened -- removing lock.", (Object[])new Object[]{this.getName()});
            log.warn((Object)msg);
            try {
                dtrProject.unlock(this.getUser());
            }
            catch (ProjectException e) {
                msg = MsgHelper.format((String)"Failed to remove lock from project ''{0}''!", (Object[])new Object[]{this.getName()});
                log.error((Object)msg, (Throwable)e);
            }
        }
    }
}

