/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project;

import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RulesInstantiationStrategyFactory;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesCache {
    private Map<Module, RulesInstantiationStrategy> moduleInstantiators = new ReferenceMap(0, 1);

    public Set<Module> getModules() {
        return this.moduleInstantiators.keySet();
    }

    public RulesInstantiationStrategy getInstantiationStrategy(Module module) {
        RulesInstantiationStrategy strategy = this.moduleInstantiators.get(module);
        if (strategy == null) {
            strategy = RulesInstantiationStrategyFactory.getStrategy(module);
            this.moduleInstantiators.put(module, strategy);
        }
        return strategy;
    }

    public void removeCachedModule(Module module) {
        this.moduleInstantiators.remove(module);
    }

    public void removeCachedProject(ProjectDescriptor project) {
        for (Module module : project.getModules()) {
            this.moduleInstantiators.remove(module);
        }
    }

    public void reset() {
        this.moduleInstantiators.clear();
    }
}

