/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openl.rules.project.IProjectDescriptorSerializer;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.model.validation.ProjectDescriptorValidator;
import org.openl.rules.project.model.validation.ValidationException;
import org.openl.rules.project.xml.XmlProjectDescriptorSerializer;

public class ProjectDescriptorManager {
    private IProjectDescriptorSerializer serializer = new XmlProjectDescriptorSerializer();
    private ProjectDescriptorValidator validator = new ProjectDescriptorValidator();

    public IProjectDescriptorSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(IProjectDescriptorSerializer serializer) {
        this.serializer = serializer;
    }

    private ProjectDescriptor readDescriptorInternal(InputStream source) {
        return this.serializer.deserialize(source);
    }

    public ProjectDescriptor readDescriptor(File filename) throws FileNotFoundException, ValidationException {
        FileInputStream inputStream = new FileInputStream(filename);
        ProjectDescriptor descriptor = this.readDescriptorInternal(inputStream);
        this.postProcess(descriptor, filename);
        this.validator.validate(descriptor);
        return descriptor;
    }

    public ProjectDescriptor readDescriptor(String filename) throws FileNotFoundException, ValidationException {
        File source = new File(filename);
        return this.readDescriptor(source);
    }

    public void writeDescriptor(ProjectDescriptor descriptor, OutputStream dest) throws IOException, ValidationException {
        this.validator.validate(descriptor);
        String serializedObject = this.serializer.serialize(descriptor);
        dest.write(serializedObject.getBytes());
    }

    private void postProcess(ProjectDescriptor descriptor, File projectDescriptorFile) {
        File projectRoot = projectDescriptorFile.getParentFile();
        descriptor.setProjectFolder(projectRoot);
        for (Module module : descriptor.getModules()) {
            module.setProject(descriptor);
        }
    }
}

