/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.CompiledOpenClass;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.model.Module;
import org.openl.rules.runtime.ApiBasedRulesEngineFactory;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiBasedEngineFactoryInstantiationStrategy
extends RulesInstantiationStrategy {
    private static final Log LOG = LogFactory.getLog(ApiBasedEngineFactoryInstantiationStrategy.class);
    private ApiBasedRulesEngineFactory factory;
    private ClassLoader classLoader;

    public ApiBasedEngineFactoryInstantiationStrategy(Module module, boolean executionMode) {
        super(module, executionMode);
        this.getEngineFactory();
    }

    private ApiBasedRulesEngineFactory getEngineFactory() {
        if (this.factory == null) {
            File sourceFile = new File(this.getModule().getRulesRootPath().getPath());
            FileSourceCodeModule source = new FileSourceCodeModule(sourceFile, null);
            source.setParams(this.getModule().getProperties());
            this.factory = new ApiBasedRulesEngineFactory((IOpenSourceCodeModule)source);
            this.factory.setExecutionMode(this.isExecutionMode());
        }
        return this.factory;
    }

    @Override
    protected void forcedReset() {
        super.forcedReset();
        this.factory.reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getServiceClass() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            Class clazz = this.getEngineFactory().getInterfaceClass();
            return clazz;
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot resolve interface", (Throwable)e);
            Class<?> clazz = null;
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompiledOpenClass compile(Class<?> clazz, boolean useExisting) throws InstantiationException, IllegalAccessException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            if (!useExisting) {
                this.factory.reset(false);
            }
            CompiledOpenClass compiledOpenClass = this.factory.getCompiledOpenClass();
            return compiledOpenClass;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object instantiate(Class<?> clazz, boolean useExisting) throws InstantiationException, IllegalAccessException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
        try {
            if (!useExisting) {
                this.factory.reset(false);
            }
            Object object = this.factory.makeInstance();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

