/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.CompiledOpenClass;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.exception.OpenLRuntimeException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessages;
import org.openl.message.Severity;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.project.instantiation.InitializingListener;
import org.openl.rules.project.instantiation.ReloadType;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RulesInstantiationStrategyFactory;
import org.openl.rules.project.instantiation.SharedClassLoader;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.RulesProjectResolver;
import org.openl.rules.runtime.RulesFactory;
import org.openl.runtime.AEngineFactory;
import org.openl.runtime.AOpenLEngineFactory;
import org.openl.runtime.IEngineWrapper;
import org.openl.runtime.OpenLInvocationHandler;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiProjectEngineFactory
extends AOpenLEngineFactory {
    private static final Log LOG = LogFactory.getLog(MultiProjectEngineFactory.class);
    private File rootFolder;
    private RulesProjectResolver projectResolver = RulesProjectResolver.loadProjectResolverFromClassPath();
    private IOpenClass compiledOpenClass;
    private Class<?> interfaceClass;
    private SharedClassLoader classLoader;
    private List<InitializingListener> listeners = new ArrayList<InitializingListener>();

    public MultiProjectEngineFactory(File rootFolder) {
        super("org.openl.xls");
        this.rootFolder = rootFolder;
    }

    public RulesProjectResolver getProjectResolver() {
        return this.projectResolver;
    }

    public void setProjectResolver(RulesProjectResolver projectResolver) {
        this.projectResolver = projectResolver;
    }

    public void addInitializingListener(InitializingListener listener) {
        this.listeners.add(listener);
    }

    public void removeInitializingListener(InitializingListener listener) {
        this.listeners.remove(listener);
    }

    public IOpenClass getOpenClass() {
        if (this.compiledOpenClass == null) {
            OpenLMessages.getCurrentInstance().clear();
            this.compiledOpenClass = this.initializeOpenClass();
        }
        return this.compiledOpenClass;
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass == null) {
            IOpenClass openClass = this.getOpenClass();
            String className = openClass.getName();
            try {
                this.interfaceClass = RulesFactory.generateInterface((String)className, (IOpenClass)openClass, (ClassLoader)this.getDefaultUserClassLoader());
            }
            catch (Exception e) {
                throw new OpenLRuntimeException("Failed to create interface : " + className, (Throwable)e);
            }
        }
        return this.interfaceClass;
    }

    protected Class<?>[] getInstanceInterfaces() {
        return new Class[]{this.interfaceClass, IEngineWrapper.class};
    }

    protected SharedClassLoader getDefaultUserClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new SharedClassLoader(super.getDefaultUserClassLoader());
        }
        return this.classLoader;
    }

    public Object makeInstance() {
        try {
            this.compiledOpenClass = this.getOpenClass();
            IRuntimeEnv runtimeEnv = this.getOpenL().getVm().getRuntimeEnv();
            Object openClassInstance = this.compiledOpenClass.newInstance(runtimeEnv);
            Map methodMap = this.makeMethodMap(this.getInterfaceClass(), this.compiledOpenClass);
            return this.makeEngineInstance(openClassInstance, methodMap, runtimeEnv, this.getDefaultUserClassLoader());
        }
        catch (Exception ex) {
            throw new OpenLRuntimeException("Cannot instantiate engine instance", (Throwable)ex);
        }
    }

    protected InvocationHandler makeInvocationHandler(Object openClassInstance, Map<Method, IOpenMember> methodMap, IRuntimeEnv runtimeEnv) {
        return new OpenLInvocationHandler(openClassInstance, (AEngineFactory)this, runtimeEnv, methodMap);
    }

    private IOpenClass initializeOpenClass() {
        this.projectResolver.setWorkspace(this.rootFolder.getAbsolutePath());
        List<ProjectDescriptor> projects = this.projectResolver.listOpenLProjects();
        List<CompiledOpenClass> compiledModules = this.initializeProjects(projects);
        IOpenClass mergedOpenClass = this.assembleModules(compiledModules);
        return mergedOpenClass;
    }

    private IOpenClass assembleModules(List<CompiledOpenClass> compiledModules) {
        XlsModuleOpenClass openClass = new XlsModuleOpenClass(null, "RulesMultiModuleOpenClass", null, this.getOpenL());
        HashMap types = new HashMap();
        HashMap fields = new HashMap();
        ArrayList<IOpenMethod> methods = new ArrayList<IOpenMethod>();
        for (CompiledOpenClass compiledModule : compiledModules) {
            Map moduleFields;
            IOpenClass moduleClass = compiledModule.getOpenClass();
            Map moduleTypes = moduleClass.getTypes();
            if (moduleTypes != null) {
                for (Map.Entry entry : moduleTypes.entrySet()) {
                    if (types.containsKey(entry.getKey())) {
                        LOG.warn((Object)String.format("Type '%s' already defined", entry.getKey()));
                        continue;
                    }
                    types.put(entry.getKey(), entry.getValue());
                }
            }
            if ((moduleFields = moduleClass.getFields()) != null) {
                for (Map.Entry entry : moduleFields.entrySet()) {
                    if (entry.getValue() instanceof ModuleOpenClass.ThisField) continue;
                    if (fields.containsKey(entry.getKey())) {
                        LOG.error((Object)String.format("Field '%s' is already defined", entry.getKey()));
                        throw new OpenLRuntimeException(String.format("Duplicate field '%s' is found", entry.getKey()));
                    }
                    fields.put(entry.getKey(), entry.getValue());
                }
            }
            List moduleMethods = moduleClass.getMethods();
            for (IOpenMethod method : moduleMethods) {
                if (method instanceof DatatypeOpenClass.OpenFieldsConstructor || method instanceof ADynamicClass.OpenConstructor || method instanceof JavaOpenConstructor || method instanceof ModuleOpenClass.GetOpenClass) continue;
                methods.add(method);
            }
        }
        for (String name : types.keySet()) {
            try {
                openClass.addType(name, (IOpenClass)types.get(name));
            }
            catch (Exception e) {
                throw new OpenLRuntimeException(String.format("Cannot import type '%s'", name));
            }
        }
        for (String name : fields.keySet()) {
            try {
                openClass.addField((IOpenField)fields.get(name));
            }
            catch (Exception e) {
                throw new OpenLRuntimeException(String.format("Cannot import field '%s'", name));
            }
        }
        for (IOpenMethod method : methods) {
            openClass.addMethod(method);
        }
        return openClass;
    }

    private List<CompiledOpenClass> initializeProjects(List<ProjectDescriptor> projects) {
        ArrayList<CompiledOpenClass> compiledModules = new ArrayList<CompiledOpenClass>();
        for (ProjectDescriptor project : projects) {
            compiledModules.addAll(this.initializeProject(project));
        }
        return compiledModules;
    }

    private List<CompiledOpenClass> initializeProject(ProjectDescriptor project) {
        ArrayList<CompiledOpenClass> compiledModules = new ArrayList<CompiledOpenClass>();
        ClassLoader projectClassLoader = project.getClassLoader(false);
        this.getDefaultUserClassLoader().addClassLoader(projectClassLoader);
        project.setClassLoader(this.getDefaultUserClassLoader());
        for (Module module : project.getModules()) {
            for (InitializingListener listener : this.listeners) {
                listener.afterModuleLoad(module);
            }
            CompiledOpenClass compiledModule = this.initializeModule(module);
            if (compiledModule.getOpenClass() instanceof NullOpenClass || compiledModule.hasErrors()) {
                LOG.error((Object)String.format("Module '%s' is not loaded and will skipped", module.getName()));
                throw new OpenLRuntimeException("Project cannot be loaded");
            }
            compiledModules.add(compiledModule);
        }
        return compiledModules;
    }

    private CompiledOpenClass initializeModule(Module module) {
        RulesInstantiationStrategy instantiationStrategy = RulesInstantiationStrategyFactory.getStrategy(module, true);
        CompiledOpenClass compiledOpenClass = null;
        try {
            compiledOpenClass = instantiationStrategy.compile(ReloadType.NO);
        }
        catch (Throwable t) {
            LOG.error((Object)String.format("Cannot load module '%s'", module.getName()), t);
            OpenLMessage message = new OpenLMessage(String.format("Cannot load the module: %s", ExceptionUtils.getRootCauseMessage((Throwable)t)), "", Severity.ERROR);
            ArrayList<OpenLMessage> messages = new ArrayList<OpenLMessage>();
            messages.add(message);
            compiledOpenClass = new CompiledOpenClass((IOpenClass)NullOpenClass.the, messages, new SyntaxNodeException[0], new SyntaxNodeException[0]);
        }
        return compiledOpenClass;
    }
}

