/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.CompiledOpenClass;
import org.openl.rules.project.instantiation.InitializingListener;
import org.openl.rules.project.instantiation.MultiProjectEngineFactory;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiProjectEngineFactoryInstantiationStrategy
extends RulesInstantiationStrategy {
    private static final Log LOG = LogFactory.getLog(MultiProjectEngineFactoryInstantiationStrategy.class);
    private File root;
    private MultiProjectEngineFactory factory;

    public MultiProjectEngineFactoryInstantiationStrategy(File root) {
        super(null, true);
        this.root = root;
        this.getEngineFactory();
    }

    private MultiProjectEngineFactory getEngineFactory() {
        if (this.factory == null) {
            this.factory = new MultiProjectEngineFactory(this.root);
        }
        return this.factory;
    }

    @Override
    protected void forcedReset() {
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.factory.getDefaultUserClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getServiceClass() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            Class<?> clazz = this.getEngineFactory().getInterfaceClass();
            return clazz;
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot resolve interface", (Throwable)e);
            Class<?> clazz = null;
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public void addInitializingListener(InitializingListener listener) {
        this.getEngineFactory().addInitializingListener(listener);
    }

    public void removeInitializingListener(InitializingListener listener) {
        this.getEngineFactory().removeInitializingListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompiledOpenClass compile(Class<?> clazz, boolean useExisting) throws InstantiationException, IllegalAccessException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            IOpenClass openClass = this.factory.getOpenClass();
            CompiledOpenClass compiledOpenClass = new CompiledOpenClass(openClass, new ArrayList(), new SyntaxNodeException[0], new SyntaxNodeException[0]);
            return compiledOpenClass;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object instantiate(Class<?> clazz, boolean useExisting) throws InstantiationException, IllegalAccessException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
        try {
            Object object = this.factory.makeInstance();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

