/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import org.openl.CompiledOpenClass;
import org.openl.rules.project.instantiation.ReloadType;
import org.openl.rules.project.model.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RulesInstantiationStrategy {
    private Module module;
    private Class<?> clazz;
    private boolean executionMode;

    public RulesInstantiationStrategy(Module module, boolean executionMode) {
        this.module = module;
        this.executionMode = executionMode;
    }

    public Module getModule() {
        return this.module;
    }

    protected boolean isExecutionMode() {
        return this.executionMode;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public Class<?> getServiceClass() throws ClassNotFoundException {
        if (this.clazz == null) {
            this.clazz = this.getClassLoader().loadClass(this.module.getClassname());
        }
        return this.clazz;
    }

    public CompiledOpenClass compile(ReloadType reloadType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (reloadType == ReloadType.FORCED) {
            this.forcedReset();
        }
        return this.compile(this.getServiceClass(), reloadType == ReloadType.NO);
    }

    public Object instantiate(ReloadType reloadType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (reloadType == ReloadType.FORCED) {
            this.forcedReset();
        }
        return this.instantiate(this.getServiceClass(), reloadType == ReloadType.NO);
    }

    protected void forcedReset() {
        this.getModule().getProject().getClassLoader(true);
    }

    protected ClassLoader getClassLoader() {
        return this.module.getProject().getClassLoader(false);
    }

    protected abstract Object instantiate(Class<?> var1, boolean var2) throws InstantiationException, IllegalAccessException;

    protected abstract CompiledOpenClass compile(Class<?> var1, boolean var2) throws InstantiationException, IllegalAccessException;
}

