/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.project.instantiation.ApiBasedEngineFactoryInstantiationStrategy;
import org.openl.rules.project.instantiation.EngineFactoryInstantiationStrategy;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.WrapperAdjustingInstantiationStrategy;
import org.openl.rules.project.model.Module;

public class RulesInstantiationStrategyFactory {
    public static RulesInstantiationStrategy getStrategy(Module moduleInfo) {
        return RulesInstantiationStrategyFactory.getStrategy(moduleInfo, false);
    }

    public static RulesInstantiationStrategy getStrategy(Module moduleInfo, boolean executionMode) {
        switch (moduleInfo.getType()) {
            case DYNAMIC: {
                return new EngineFactoryInstantiationStrategy(moduleInfo, executionMode);
            }
            case STATIC: {
                return new WrapperAdjustingInstantiationStrategy(moduleInfo, executionMode);
            }
            case API: {
                return new ApiBasedEngineFactoryInstantiationStrategy(moduleInfo, executionMode);
            }
        }
        throw new OpenLRuntimeException(String.format("Cannot resolve instantiation strategy for \"%s\"", moduleInfo.getType().toString()));
    }
}

