/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.context.IRulesRuntimeContextProvider;
import org.openl.rules.project.instantiation.ReloadType;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RulesServiceEnhancerInvocationHandler;
import org.openl.rules.runtime.RuleInfo;
import org.openl.rules.runtime.RulesFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesServiceEnhancer {
    private static final Log LOG = LogFactory.getLog(RulesServiceEnhancer.class);
    private static final String CLASS_NAME_SUFFIX = "$RulesEnhanced";
    private RulesInstantiationStrategy instantiationStrategy;
    private Class<?> serviceClass;

    public RulesServiceEnhancer(RulesInstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    public Class<?> getServiceClass() throws ClassNotFoundException, InstantiationException {
        if (this.serviceClass == null) {
            Class<?> originalServiceClass = this.instantiationStrategy.getServiceClass();
            try {
                this.serviceClass = this.decorateMethods(originalServiceClass);
            }
            catch (Exception e) {
                throw new InstantiationException(e.getMessage());
            }
        }
        return this.serviceClass;
    }

    public Object instantiate(ReloadType reloadType) throws InstantiationException {
        try {
            InvocationHandler handler = this.makeInvocationHandler(reloadType);
            return Proxy.newProxyInstance(this.instantiationStrategy.getClassLoader(), this.getProxyInterfaces(), handler);
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    private InvocationHandler makeInvocationHandler(ReloadType reloadType) throws Exception {
        Map<Method, Method> methodsMap = this.makeMethodMap(this.getServiceClass(), this.instantiationStrategy.getServiceClass());
        return new RulesServiceEnhancerInvocationHandler(methodsMap, this.instantiationStrategy.instantiate(reloadType));
    }

    private Class<?>[] getProxyInterfaces() throws Exception {
        return new Class[]{this.getServiceClass()};
    }

    private Class<?> decorateMethods(Class<?> clazz) throws Exception {
        Method[] methods = clazz.getMethods();
        List<RuleInfo> rules = this.getRules(methods);
        String className = clazz.getName() + CLASS_NAME_SUFFIX;
        RuleInfo[] rulesArray = rules.toArray(new RuleInfo[rules.size()]);
        ClassLoader classLoader = this.instantiationStrategy.getClassLoader();
        LOG.debug((Object)String.format("Generating proxy interface for '%s' class", clazz.getName()));
        return RulesFactory.generateInterface((String)className, (RuleInfo[])rulesArray, (ClassLoader)classLoader);
    }

    private List<RuleInfo> getRules(Method[] methods) {
        ArrayList<RuleInfo> rules = new ArrayList<RuleInfo>(methods.length);
        for (Method method : methods) {
            if (ArrayUtils.contains((Object[])IRulesRuntimeContextProvider.class.getMethods(), (Object)method)) continue;
            String methodName = method.getName();
            Object[] paramTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            Object[] newParams = new Class[]{IRulesRuntimeContext.class};
            Class[] extendedParamTypes = (Class[])ArrayUtils.addAll((Object[])newParams, (Object[])paramTypes);
            RuleInfo ruleInfo = RulesFactory.createRuleInfo((String)methodName, (Class[])extendedParamTypes, returnType);
            rules.add(ruleInfo);
        }
        return rules;
    }

    private Map<Method, Method> makeMethodMap(Class<?> interfaceClass, Class<?> serviceClass) {
        Method[] serviceMethods;
        LOG.debug((Object)String.format("Creating methods map for classes: %s <-> %s", interfaceClass, serviceClass));
        HashMap<Method, Method> methodMap = new HashMap<Method, Method>();
        for (Method serviceMethod : serviceMethods = serviceClass.getDeclaredMethods()) {
            String interfaceMethodName = serviceMethod.getName();
            Object[] serviceMethodParameterTypes = serviceMethod.getParameterTypes();
            Object[] newParams = new Class[]{IRulesRuntimeContext.class};
            Class[] extendedParamTypes = (Class[])ArrayUtils.addAll((Object[])newParams, (Object[])serviceMethodParameterTypes);
            try {
                Method interfaceMethod = interfaceClass.getMethod(interfaceMethodName, extendedParamTypes);
                methodMap.put(interfaceMethod, serviceMethod);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        LOG.debug((Object)((Object)methodMap).toString());
        return methodMap;
    }
}

