/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.context.IRulesRuntimeContextConsumer;
import org.openl.runtime.IEngineWrapper;
import org.openl.runtime.IRuntimeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RulesServiceEnhancerInvocationHandler
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog(RulesServiceEnhancerInvocationHandler.class);
    private Map<Method, Method> methodsMap;
    private Object serviceClassInstance;

    public RulesServiceEnhancerInvocationHandler(Map<Method, Method> methodsMap, Object serviceClassInstance) {
        this.methodsMap = methodsMap;
        this.serviceClassInstance = serviceClassInstance;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method member = this.methodsMap.get(method);
        LOG.debug((Object)String.format("Invoking service class method: %s -> %s", method.toString(), member.toString()));
        IRulesRuntimeContext context = (IRulesRuntimeContext)args[0];
        Object[] methodArgs = ArrayUtils.remove((Object[])args, (int)0);
        this.applyRulesRuntimeContext(this.serviceClassInstance, context);
        return member.invoke(this.serviceClassInstance, methodArgs);
    }

    private void applyRulesRuntimeContext(Object serviceInstance, IRulesRuntimeContext context) {
        Class<?> serviceClass = serviceInstance.getClass();
        if (IEngineWrapper.class.isAssignableFrom(serviceClass)) {
            LOG.debug((Object)String.format("Applying runtime context: %s thru IEngineWrapper instance", context.toString()));
            IEngineWrapper wrapper = (IEngineWrapper)serviceInstance;
            wrapper.getRuntimeEnv().setContext((IRuntimeContext)context);
        } else if (IRulesRuntimeContextConsumer.class.isAssignableFrom(serviceClass)) {
            LOG.debug((Object)String.format("Applying runtime context: %s thru IRulesRuntimeContextConsumer instance", context.toString()));
            IRulesRuntimeContextConsumer wrapper = (IRulesRuntimeContextConsumer)serviceInstance;
            wrapper.setRuntimeContext(context);
        } else {
            LOG.error((Object)"Cannot define rules runtime context for service instance. Service class must be instance one of: IEngineWrapper.class, IRulesRuntimeContextConsumer.class");
        }
    }
}

