/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.CompiledOpenClass;
import org.openl.main.OpenLWrapper;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RulesInstantiationStrategyFactory;
import org.openl.rules.project.model.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperAdjustingInstantiationStrategy
extends RulesInstantiationStrategy {
    private static final Log LOG = LogFactory.getLog(RulesInstantiationStrategyFactory.class);
    private OpenLWrapper wrapper;

    public WrapperAdjustingInstantiationStrategy(Module module, boolean executionMode) {
        super(module, executionMode);
    }

    @Override
    protected CompiledOpenClass compile(Class<?> clazz, boolean useExisting) throws InstantiationException, IllegalAccessException {
        OpenLWrapper wrapper = this.instantiate(clazz, useExisting);
        return wrapper.getCompiledOpenClass();
    }

    public Object wrapperNewInstance(Class<?> c) throws Exception {
        try {
            Method m = c.getMethod("reset", new Class[0]);
            m.invoke(null, new Object[0]);
            if (this.isExecutionMode()) {
                Constructor<?> ctr = c.getConstructor(Boolean.TYPE, Boolean.TYPE);
                return ctr.newInstance(Boolean.FALSE, Boolean.TRUE);
            }
            Constructor<?> ctr = c.getConstructor(Boolean.TYPE);
            return ctr.newInstance(Boolean.TRUE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Using older version of OpenL Wrapper, please run Generate ... Wrapper");
        }
    }

    private void preInitWrapper(Class<?> clazz) throws Exception {
        String projectFolder = this.getModule().getProject().getProjectFolder().getAbsolutePath();
        Field userHomeField = clazz.getField("__userHome");
        if (!Modifier.isStatic(userHomeField.getModifiers())) {
            throw new RuntimeException("Field " + userHomeField.getName() + " is not static in " + userHomeField.getDeclaringClass().getName());
        }
        userHomeField.set(null, projectFolder);
        try {
            Field field = clazz.getField("__src");
            String sourcePath = (String)field.get(null);
            if (!new File(sourcePath).isAbsolute()) {
                field.set(null, projectFolder + '/' + sourcePath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to set up __src", e);
        }
    }

    protected OpenLWrapper instantiate(Class<?> clazz, boolean useExisting) throws InstantiationException, IllegalAccessException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
        try {
            this.preInitWrapper(clazz);
            if (!useExisting || this.wrapper == null) {
                this.wrapper = (OpenLWrapper)this.wrapperNewInstance(clazz);
            }
            OpenLWrapper openLWrapper = this.wrapper;
            return openLWrapper;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to instantiate wrapper \"" + clazz.getName() + "\""), (Throwable)e);
            throw new RuntimeException("Failed to instantiate wrapper \"" + clazz.getName() + "\"", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

